/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.service;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitChannelFactory;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConsumer;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;

public class CloudEventServiceRabbitmqImp
implements CloudEventServicePlus {
    private final CloudProps cloudProps;
    private RabbitProducer producer;
    private RabbitConsumer consumer;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServiceRabbitmqImp(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        try {
            RabbitConfig config = new RabbitConfig(cloudProps);
            config.server = cloudProps.getEventServer();
            config.username = cloudProps.getUsername();
            config.password = cloudProps.getPassword();
            RabbitChannelFactory factory = new RabbitChannelFactory(cloudProps, config);
            this.producer = new RabbitProducer(factory);
            this.consumer = new RabbitConsumer(cloudProps, this.producer, factory);
            this.producer.init();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + "::" + event.topic();
        try {
            return this.producer.publish(event, topicNew);
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + "::" + topic;
        this.observerManger.add(topicNew, level, group, topic, observer);
    }

    public void subscribe() {
        try {
            if (this.observerManger.topicSize() > 0) {
                this.consumer.init(this.observerManger);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

