/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.BuiltinExchangeType;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;

public class RabbitConfig {
    public String exchangeName;
    public BuiltinExchangeType exchangeType = BuiltinExchangeType.DIRECT;
    public boolean durable = true;
    public boolean autoDelete = false;
    public boolean internal = false;
    public boolean mandatory = false;
    public boolean immediate = false;
    public boolean exclusive = false;
    public String server;
    public String username;
    public String password;
    public String queue_normal;
    public String queue_ready;
    public String queue_retry;
    private final CloudProps cloudProps;

    public RabbitConfig(CloudProps cloudProps) {
        String queueName;
        this.cloudProps = cloudProps;
        this.exchangeName = this.getEventExchange();
        if (Utils.isEmpty((String)this.exchangeName)) {
            this.exchangeName = "DEFAULT";
        }
        if (Utils.isEmpty((String)(queueName = this.getEventQueue()))) {
            queueName = Solon.cfg().appGroup() + "_" + Solon.cfg().appName();
        }
        this.queue_normal = queueName + "@normal";
        this.queue_ready = queueName + "@ready";
        this.queue_retry = queueName + "@retry";
    }

    public String getEventExchange() {
        return this.cloudProps.getProp("event.exchange");
    }

    public String getEventQueue() {
        return this.cloudProps.getProp("event.queue");
    }
}

