/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.utils.ExpirationUtils;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitConsumeHandler
extends DefaultConsumer {
    static Logger log = LoggerFactory.getLogger(RabbitConsumeHandler.class);
    CloudEventObserverManger observerManger;
    RabbitConfig cfg;
    RabbitProducer producer;
    String eventChannelName;

    public RabbitConsumeHandler(CloudProps cloudProps, RabbitProducer producer, RabbitConfig config, Channel channel, CloudEventObserverManger observerManger) {
        super(channel);
        this.cfg = config;
        this.producer = producer;
        this.observerManger = observerManger;
        this.eventChannelName = cloudProps.getEventChannel();
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        try {
            String event_json = new String(body);
            Event event = (Event)ONode.deserialize((String)event_json, Event.class);
            event.channel(this.eventChannelName);
            boolean isOk = this.onReceive(event);
            if (!isOk) {
                event.times(event.times() + 1);
                try {
                    isOk = this.producer.publish(event, this.cfg.queue_ready, ExpirationUtils.getExpiration((int)event.times()));
                }
                catch (Throwable ex) {
                    this.getChannel().basicNack(envelope.getDeliveryTag(), false, true);
                    isOk = true;
                }
            }
            if (isOk) {
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            }
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            EventBus.push((Object)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public boolean onReceive(Event event) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        handler = this.observerManger.get(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

