/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.noear.snack.ONode;
import org.noear.solon.cloud.extend.rabbitmq.RabbitmqProps;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitChannelFactory;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.model.Event;

public class RabbitProducer {
    private RabbitConfig config;
    private Channel channel;
    private long timeout;
    private RabbitChannelFactory factory;
    private AMQP.BasicProperties eventPropsDefault;

    public RabbitProducer(RabbitChannelFactory factory) {
        this.config = factory.getConfig();
        this.factory = factory;
        this.eventPropsDefault = this.newEventProps().build();
        this.timeout = RabbitmqProps.instance.getEventPublishTimeout();
    }

    public AMQP.BasicProperties.Builder newEventProps() {
        return new AMQP.BasicProperties().builder().deliveryMode(Integer.valueOf(2)).contentEncoding("UTF-8").contentType("application/json");
    }

    public void init() throws IOException, TimeoutException {
        this.channel = this.factory.getChannel();
        HashMap args = new HashMap();
        this.channel.exchangeDeclare(this.config.exchangeName, this.config.exchangeType, this.config.durable, this.config.autoDelete, this.config.internal, args);
        if (this.timeout > 0L) {
            this.channel.confirmSelect();
        }
    }

    public boolean publish(Event event, String topic, long ttl) throws Exception {
        byte[] event_data = ONode.stringify((Object)event).getBytes(StandardCharsets.UTF_8);
        AMQP.BasicProperties props = ttl > 0L ? this.newEventProps().expiration(String.valueOf(ttl)).build() : this.eventPropsDefault;
        this.channel.basicPublish(this.config.exchangeName, topic, this.config.mandatory, props, event_data);
        if (this.timeout > 0L) {
            return this.channel.waitForConfirms(this.timeout);
        }
        return true;
    }

    public boolean publish(Event event, String topic) throws Exception {
        long ttl = 0L;
        if (event.scheduled() != null) {
            ttl = event.scheduled().getTime() - System.currentTimeMillis();
        }
        if (ttl > 0L) {
            return this.publish(event, this.config.queue_ready, ttl);
        }
        if (this.config.exchangeType == BuiltinExchangeType.FANOUT) {
            return this.publish(event, "", 0L);
        }
        return this.publish(event, topic, 0L);
    }
}

