/*
 * Decompiled with CFR 0.152.
 */
package org.noear.rock;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.noear.rock.AppCodeCollection;
import org.noear.rock.AppSettingCollection;
import org.noear.rock.RockUtil;
import org.noear.rock.dso.process.app_ex_del_setting_item;
import org.noear.rock.dso.process.app_ex_get_code;
import org.noear.rock.dso.process.app_ex_get_codes;
import org.noear.rock.dso.process.app_ex_get_setting;
import org.noear.rock.dso.process.app_ex_get_setting_item;
import org.noear.rock.dso.process.app_ex_get_setting_item_by_name;
import org.noear.rock.dso.process.app_ex_get_verson;
import org.noear.rock.dso.process.app_get_agroup;
import org.noear.rock.dso.process.app_get_app;
import org.noear.rock.dso.process.app_get_app_list;
import org.noear.rock.dso.process.app_get_ugroup;
import org.noear.rock.dso.process.app_get_whitelist;
import org.noear.rock.model.AppCodeModel;
import org.noear.rock.model.AppGroupModel;
import org.noear.rock.model.AppModel;
import org.noear.rock.model.AppSettingModel;
import org.noear.rock.model.AppUpdateModel;
import org.noear.rock.model.AppVersionModel;
import org.noear.rock.model.UpdateType;
import org.noear.rock.model.UserGroupModel;
import org.noear.water.WaterClient;
import org.noear.water.model.ConfigM;
import org.noear.water.utils.RedisX;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.IBinder;
import org.noear.weed.IQuery;
import org.noear.weed.cache.ICacheService;
import org.noear.weed.cache.ICacheServiceEx;

public final class RockClient {
    protected static DbContext rock_db;
    protected static ICacheServiceEx rock_cache;

    public static void tryInit(ICacheServiceEx cache) {
        rock_db = WaterClient.Config.get("sponge", "sponge_rock").getDb(true);
        rock_cache = cache;
    }

    public static void tryInit(ICacheServiceEx cache, DbContext db) {
        rock_db = db;
        rock_cache = cache;
    }

    public static DbContext db() {
        return rock_db;
    }

    public static AppModel addApp(int agroupID, int ugroupID, String name) throws SQLException {
        String appKey = RockUtil.buildAppkey();
        String akey = RockUtil.buildAkey();
        long app_id = RockClient.db().table("appx").set("agroup_id", (Object)agroupID).set("ugroup_id", (Object)ugroupID).set("app_key", (Object)appKey).set("akey", (Object)akey).set("name", (Object)name).insert();
        return (AppModel)((DbTableQuery)RockClient.db().table("appx").where("app_id=?", new Object[]{app_id})).select("*").getItem((IBinder)new AppModel());
    }

    public static void udpAppName(int appID, String name) throws SQLException {
        ((DbTableQuery)RockClient.db().table("appx").set("name", (Object)name).where("app_id=?", new Object[]{appID})).update();
        RockClient.delCacheByApp(appID);
    }

    public static void udpAppExamine(int appID, int isExamine, int examineVer) throws SQLException {
        ((DbTableQuery)RockClient.db().table("appx").set("ar_is_examine", (Object)isExamine).set("ar_examine_ver", (Object)examineVer).where("app_id=?", new Object[]{appID})).update();
        RockClient.delCacheByApp(appID);
    }

    public static AppModel getAppById(int appID) throws SQLException {
        app_get_app sp = new app_get_app(rock_db);
        sp.app_id = appID;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_" + appID);
        return (AppModel)sp.getItem(new AppModel());
    }

    public static AppModel getAppByKey(String akey) throws SQLException {
        app_get_app sp = new app_get_app(rock_db);
        sp.akey = akey;
        sp.caching((ICacheService)rock_cache).usingCache(600);
        return (AppModel)sp.getItem(new AppModel(), (cu, m) -> cu.cacheTag("app_" + m.app_id));
    }

    public static List<AppModel> getAppsByGroup(int agroupID, int ugroupID) throws Exception {
        if (agroupID < 1 && ugroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroupID \u6216 ugroupID");
        }
        app_get_app_list sp = new app_get_app_list(rock_db);
        sp.agroup_id = agroupID;
        sp.ugroup_id = ugroupID;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_list_" + agroupID);
        return sp.getList(new AppModel());
    }

    public static AppGroupModel getAppGroup(int agroupID) throws Exception {
        if (agroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroupID");
        }
        app_get_agroup sp = new app_get_agroup(rock_db);
        sp.agroup_id = agroupID;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_group_" + agroupID);
        return (AppGroupModel)sp.getItem(new AppGroupModel());
    }

    public static UserGroupModel getUserGroup(int ugroupID) throws Exception {
        if (ugroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 ugroupID");
        }
        app_get_ugroup sp = new app_get_ugroup(rock_db);
        sp.ugroup_id = ugroupID;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("user_group_" + ugroupID);
        return (UserGroupModel)sp.getItem(new UserGroupModel());
    }

    public static AppSettingCollection getAppSetting(int appID, int verStart, boolean isClientOnly) throws Exception {
        if (appID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 app_id");
        }
        app_ex_get_setting sp = new app_ex_get_setting(rock_db);
        sp.app_id = appID;
        sp.is_client_only = isClientOnly;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_setting_" + appID);
        List tmp = sp.getList(new AppSettingModel());
        ArrayList<AppSettingModel> mod = new ArrayList<AppSettingModel>();
        for (AppSettingModel m : tmp) {
            if (verStart < m.ver_start) continue;
            mod.add(m);
        }
        AppSettingCollection set = new AppSettingCollection();
        set.bind(mod);
        return set;
    }

    public static AppSettingModel getAppSettingItem(int appID, String name) throws Exception {
        if (appID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 appID");
        }
        app_ex_get_setting_item sp = new app_ex_get_setting_item(rock_db);
        sp.app_id = appID;
        sp.name = name;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_setting_" + appID);
        return (AppSettingModel)sp.getItem(new AppSettingModel());
    }

    public static AppSettingModel getAppSettingItemNoCache(int appID, String name) throws Exception {
        if (appID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 appID");
        }
        app_ex_get_setting_item sp = new app_ex_get_setting_item(rock_db);
        sp.app_id = appID;
        sp.name = name;
        return (AppSettingModel)sp.getItem(new AppSettingModel());
    }

    public static boolean delAppSettingItem(int appID, String name) throws Exception {
        if (appID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 appID");
        }
        app_ex_del_setting_item sp = new app_ex_del_setting_item(rock_db);
        sp.app_id = appID;
        sp.name = name;
        boolean isOk = sp.execute() > 0;
        rock_cache.tags().clear("app_setting_by_name_" + name);
        RockClient.delCacheByApp(appID);
        return isOk;
    }

    public static AppSettingCollection getAppSettingEx(int appID, int ver, boolean isClientOnly) throws Exception {
        int agroup_id = RockClient.getAppById((int)appID).agroup_id;
        return RockClient.getAppSettingEx2(agroup_id, appID, ver, isClientOnly);
    }

    public static AppSettingCollection getAppSettingEx2(int groupID, int appID, int ver, boolean isClientOnly) throws Exception {
        if (appID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 appID");
        }
        AppSettingCollection sets = RockClient.getAppGroupSetting(groupID, ver, isClientOnly);
        AppSettingCollection temp = RockClient.getAppSetting(appID, ver, isClientOnly);
        for (String k : temp.keySet()) {
            AppSettingModel v = (AppSettingModel)temp.get(k);
            if (v.value == null || v.value.length() <= 0) continue;
            sets.put(k, v);
        }
        return sets;
    }

    public static List<AppSettingModel> getAppSettingItemsByName(int agroupID, String name) throws Exception {
        if (agroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroupID");
        }
        app_ex_get_setting_item_by_name sp = new app_ex_get_setting_item_by_name(rock_db);
        sp.agroup_id = agroupID;
        sp.name = name;
        ((IQuery)((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_setting_by_name_" + name)).cacheTag("app_setting_by_name_" + agroupID);
        return sp.getList(new AppSettingModel());
    }

    public static AppSettingModel getAppSettingItemEx(int appID, String name) throws Exception {
        if (appID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 appID");
        }
        AppSettingModel item = RockClient.getAppSettingItem(appID, name);
        if (item.row_id > 0) {
            return item;
        }
        int agroup_id = RockClient.getAppById((int)appID).agroup_id;
        return RockClient.getAppGroupSettingItem(agroup_id, name);
    }

    public static void setAppSettingItem(int appID, String name, int type, String value, int verStart, boolean isClient) throws Exception {
        if (appID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 appID");
        }
        int agroup_id = RockClient.getAppById((int)appID).agroup_id;
        if (((DbTableQuery)RockClient.db().table("appx_ex_setting").where("app_id=? AND name=?", new Object[]{appID, name})).exists()) {
            ((DbTableQuery)RockClient.db().table("appx_ex_setting").set("agroup_id", (Object)agroup_id).set("type", (Object)type).set("value", (Object)value).set("ver_start", (Object)verStart).set("is_client", (Object)(isClient ? 1 : 0)).where("app_id=? AND name=?", new Object[]{appID, name})).update();
        } else {
            RockClient.db().table("appx_ex_setting").set("agroup_id", (Object)agroup_id).set("app_id", (Object)appID).set("name", (Object)name).set("type", (Object)type).set("value", (Object)value).set("ver_start", (Object)verStart).set("is_client", (Object)(isClient ? 1 : 0)).insert();
        }
        rock_cache.tags().clear("app_setting_by_name_" + name);
        RockClient.delCacheByApp(appID);
    }

    public static AppSettingCollection getAppGroupSetting(int agroupID, int verStart, boolean isClientOnly) throws Exception {
        if (agroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroup_id");
        }
        app_ex_get_setting sp = new app_ex_get_setting(rock_db);
        sp.agroup_id = agroupID;
        sp.is_client_only = isClientOnly;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_group_setting_" + agroupID);
        List tmp = sp.getList(new AppSettingModel());
        ArrayList<AppSettingModel> mod = new ArrayList<AppSettingModel>();
        for (AppSettingModel m : tmp) {
            if (verStart < m.ver_start) continue;
            mod.add(m);
        }
        AppSettingCollection set = new AppSettingCollection();
        set.bind(mod);
        return set;
    }

    public static AppSettingModel getAppGroupSettingItem(int agroupID, String name) throws Exception {
        if (agroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroup_id");
        }
        app_ex_get_setting_item sp = new app_ex_get_setting_item(rock_db);
        sp.agroup_id = agroupID;
        sp.name = name;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_group_setting_" + agroupID);
        return (AppSettingModel)sp.getItem(new AppSettingModel());
    }

    public static AppSettingModel getAppGroupSettingItemNoCache(int agroupID, String name) throws Exception {
        if (agroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroup_id");
        }
        app_ex_get_setting_item sp = new app_ex_get_setting_item(rock_db);
        sp.agroup_id = agroupID;
        sp.name = name;
        return (AppSettingModel)sp.getItem(new AppSettingModel());
    }

    public static boolean delAppGroupSettingItem(int agroupID, String name) throws Exception {
        if (agroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroupID");
        }
        app_ex_del_setting_item sp = new app_ex_del_setting_item(rock_db);
        sp.agroup_id = agroupID;
        sp.name = name;
        boolean isOk = sp.execute() > 0;
        RockClient.delCacheByAppGroup(agroupID);
        return isOk;
    }

    public static void setAppGroupSettingItem(int agroupID, String name, int type, String value, int verStart, boolean isClient) throws Exception {
        if (agroupID < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6709\u6548\u7684 agroup_id");
        }
        if (((DbTableQuery)RockClient.db().table("appx_ex_setting").where("agroup_id=? AND app_id=0 AND name=?", new Object[]{agroupID, name})).exists()) {
            ((DbTableQuery)RockClient.db().table("appx_ex_setting").set("type", (Object)type).set("value", (Object)value).set("ver_start", (Object)verStart).set("is_client", (Object)(isClient ? 1 : 0)).where("agroup_id=? AND app_id=0 AND name=?", new Object[]{agroupID, name})).update();
        } else {
            RockClient.db().table("appx_ex_setting").set("agroup_id", (Object)agroupID).set("app_id", (Object)0).set("name", (Object)name).set("type", (Object)type).set("value", (Object)value).set("ver_start", (Object)verStart).set("is_client", (Object)(isClient ? 1 : 0)).insert();
        }
        RockClient.delCacheByAppGroup(agroupID);
    }

    public static AppUpdateModel chkAppUpdate(int appID, int platform, int verID) throws SQLException {
        AppVersionModel ver = RockClient.getAppVersionEx(appID, platform);
        AppUpdateModel udp = new AppUpdateModel(ver);
        if (ver.force_ver > 0 && ver.force_ver > verID) {
            udp.type = UpdateType.force;
            return udp;
        }
        if (ver.alert_ver > 0) {
            if (ver.alert_ver > verID) {
                udp.type = UpdateType.alert;
                return udp;
            }
        } else if (ver.ver > verID) {
            udp.type = ver.type == 1 ? UpdateType.force : UpdateType.alert;
            return udp;
        }
        return udp;
    }

    public static AppVersionModel getAppVersionEx(int appID, int platform) throws SQLException {
        AppVersionModel ver = RockClient.doGetAppVersion(0, appID, platform);
        if (ver.app_id > 0) {
            return ver;
        }
        int agroup_id = RockClient.getAppById((int)appID).agroup_id;
        ver = RockClient.doGetAppVersion(agroup_id, 0, platform);
        return ver;
    }

    public static AppVersionModel getAppGroupVersion(int agroupID, int platform) throws SQLException {
        return RockClient.doGetAppVersion(agroupID, 0, platform);
    }

    public static AppVersionModel getAppVersion(int appID, int platform) throws SQLException {
        return RockClient.doGetAppVersion(0, appID, platform);
    }

    private static AppVersionModel doGetAppVersion(int agroupID, int appID, int platform) throws SQLException {
        app_ex_get_verson sp = new app_ex_get_verson(rock_db);
        sp.agroup_id = agroupID;
        sp.app_id = appID;
        sp.platform = platform;
        ((IQuery)((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_group_ver_" + agroupID)).cacheTag("app_ver_" + appID);
        return (AppVersionModel)sp.getItem(new AppVersionModel());
    }

    public static AppCodeCollection getAppCodes(int agroupID) throws SQLException {
        app_ex_get_codes sp = new app_ex_get_codes(rock_db);
        sp.agroup_id = agroupID;
        ((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_code_" + agroupID);
        List m = sp.getList(new AppCodeModel());
        AppCodeCollection ac = new AppCodeCollection();
        ac.bind(m);
        return ac;
    }

    public static String tryAppCode(int agroupID, int code) {
        try {
            return RockClient.getAppCode(agroupID, code);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getAppCode(int agroupID, int code) throws SQLException {
        app_ex_get_code sp = new app_ex_get_code(rock_db);
        sp.agroup_id = agroupID;
        sp.code = code;
        AppCodeModel m = (AppCodeModel)((IQuery)((IQuery)sp.caching((ICacheService)rock_cache).usingCache(600)).cacheTag("app_code_" + agroupID)).getItem((IBinder)new AppCodeModel());
        if (m.note == null) {
            return "";
        }
        return m.note;
    }

    public static boolean isWhitelist(String tag, int type, String val) throws SQLException {
        app_get_whitelist sp = new app_get_whitelist(rock_db);
        sp.type = type;
        sp.tag = tag;
        sp.value = val;
        sp.caching((ICacheService)rock_cache).cacheTag("app_whitelist_" + type + "_" + tag);
        return sp.getValue(null) != null;
    }

    public static long newID(String key, String field, int cacheTime) {
        return RockUtil.newID(key, field, cacheTime);
    }

    public static boolean isUnique(String group, String key) {
        return RockUtil.isUnique(group, key, 3);
    }

    public static boolean isUnique(String group, String key, int inSeconds) {
        return RockUtil.isUnique(group, key, inSeconds);
    }

    public static RedisX redis(int db) {
        return RockUtil.redis(db);
    }

    public static RedisX redis(int db, int maxTotal) {
        return RockUtil.redis(db, maxTotal);
    }

    public static RedisX redis(ConfigM cfg, int db, int maxTotal) {
        return RockUtil.redis(cfg, db, maxTotal);
    }

    public static void delCacheByApp(int appID) {
        if (appID < 1) {
            return;
        }
        rock_cache.tags().clear("app_setting_" + appID).clear("app_" + appID);
        RockUtil.sendMessage("app_" + appID + ";app_setting_" + appID);
    }

    public static void delCacheByAppGroup(int agroupID) {
        if (agroupID < 1) {
            return;
        }
        rock_cache.tags().clear("app_group_" + agroupID).clear("app_group_setting_" + agroupID).clear("app_setting_by_name_" + agroupID).clear("app_list_" + agroupID);
        RockUtil.sendMessage("app_group_" + agroupID + ";app_group_setting_" + agroupID + ";app_setting_by_name_" + agroupID + ";app_list_" + agroupID);
    }

    public static void delCacheForVersion(int agroupID, int appID) {
        if (appID > 0) {
            rock_cache.tags().clear("app_ver_" + appID);
            RockUtil.sendMessage("app_ver_" + appID);
        } else {
            rock_cache.tags().clear("app_group_ver_" + agroupID);
            RockUtil.sendMessage("app_group_ver_" + agroupID);
        }
    }

    public static void delCacheForCodes(int agroupID) {
        rock_cache.tags().clear("app_code_" + agroupID);
        RockUtil.sendMessage("app_code_" + agroupID);
    }

    public static void delCacheForWhiteList(String tag, int type) {
        rock_cache.tags().clear("app_whitelist_" + type + "_" + tag);
        RockUtil.sendMessage("app_whitelist_" + type + "_" + tag);
    }
}

