/*
 * Decompiled with CFR 0.152.
 */
package org.noear.rock;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.digest.DigestUtils;
import org.noear.rock.RockClient;
import org.noear.solon.Solon;
import org.noear.water.WaterClient;
import org.noear.water.model.ConfigM;
import org.noear.water.model.MessageM;
import org.noear.water.utils.RedisX;
import org.noear.weed.cache.CacheTags;

public class RockUtil {
    private static RedisX _redis_idx = null;
    private static RedisX _redis_uni = null;
    private static RedisX _redis_time = null;
    private static ReentrantLock run_lock = new ReentrantLock();
    private static ConfigM redis_cfg = null;
    private static String msg_topic = "water.cache.update";

    public static long newID(String key, String field, int cacheTime) {
        RockUtil.tryInit();
        long val = (Long)_redis_idx.open1(ru -> ru.key(key).expire(cacheTime).hashIncr(field, 1L));
        return val;
    }

    public static boolean tryLock(String group, String key, int inSeconds, String inMaster) {
        RockUtil.tryInit();
        String key2 = group + ".lk." + key;
        return (Boolean)_redis_uni.open1(ru -> {
            if (!ru.key(key2).exists().booleanValue()) {
                ru.key(key2).expire(inSeconds).lock(inMaster);
            }
            return inMaster.equals(ru.key(key2).get());
        });
    }

    public static boolean tryLock(String group, String key, int inSeconds) {
        RockUtil.tryInit();
        String key2 = group + ".lk." + key;
        return (Boolean)_redis_uni.open1(ru -> {
            if (!ru.key(key2).exists().booleanValue()) {
                return ru.key(key2).expire(inSeconds).lock("_");
            }
            return false;
        });
    }

    public static boolean isLocked(String group, String key) {
        RockUtil.tryInit();
        String key2 = group + ".lk." + key;
        return (Boolean)_redis_uni.open1(ru -> ru.key(key2).exists());
    }

    public static void unLock(String group, String key) {
        RockUtil.tryInit();
        String key2 = group + ".lk." + key;
        _redis_uni.open0(ru -> ru.key(key2).delete());
    }

    public static boolean isUnique(String group, String key) {
        return RockUtil.isUnique(group, key, 3);
    }

    public static boolean isUnique(String group, String key, int inSeconds) {
        RockUtil.tryInit();
        String key2 = group + key;
        long val = (Long)_redis_uni.open1(ru -> {
            if (ru.key(key2).exists().booleanValue()) {
                return 2L;
            }
            return ru.key(key2).expire(inSeconds).incr(1L);
        });
        return val == 1L;
    }

    public static RedisX redis(int db) {
        if (redis_cfg == null) {
            redis_cfg = WaterClient.Config.get("sponge", "rock_redis");
        }
        return RockUtil.redis(redis_cfg, db, 300);
    }

    public static RedisX redis(int db, int maxTotal) {
        if (redis_cfg == null) {
            redis_cfg = WaterClient.Config.get("sponge", "rock_redis");
        }
        return RockUtil.redis(redis_cfg, db, maxTotal);
    }

    public static RedisX redis(ConfigM cfg, int db, int maxTotal) {
        return new RedisX((Properties)cfg.getProp(), db, maxTotal);
    }

    private static void tryInit() {
        if (_redis_idx == null) {
            run_lock.lock();
            if (_redis_idx == null) {
                try {
                    _redis_idx = RockUtil.redis(1);
                    _redis_uni = RockUtil.redis(2);
                    _redis_time = RockUtil.redis(5);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            run_lock.unlock();
        }
    }

    protected static void sendMessage(String message) {
        try {
            WaterClient.Message.sendMessage(RockUtil.buildGuid(), msg_topic, message);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void subscribeTopic(String subscriber_key, String receiver_url, String access_key) throws Exception {
        WaterClient.Message.subscribeTopic(subscriber_key, receiver_url, access_key, "18658857337", 1, Solon.cfg().isDriftMode(), new String[]{msg_topic});
    }

    public static boolean receiveMessage(MessageM msg) {
        if (!msg_topic.equals(msg.topic)) {
            return false;
        }
        try {
            String[] tag_keys;
            CacheTags cacheTags = RockClient.rock_cache.tags();
            for (String tk : tag_keys = msg.message.split(";")) {
                cacheTags.clear(tk);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static String buildUkey(int ugroupID, String mobile) {
        return RockUtil.md5(ugroupID + "#" + mobile);
    }

    public static String buildAppkey() {
        char[] chars = new char[16];
        for (int i = 0; i < 16; ++i) {
            int f = (int)(Math.random() * 3.0);
            chars[i] = f == 0 ? (char)(65.0 + Math.random() * 26.0) : (f == 1 ? (char)(97.0 + Math.random() * 26.0) : (char)(48.0 + Math.random() * 10.0));
        }
        return new String(chars);
    }

    public static String buildAkey() {
        return RockUtil.buildGuid();
    }

    public static String buildGuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String md5(String str) {
        String s = null;
        try {
            byte[] data = str.getBytes("UTF-8");
            s = DigestUtils.md5Hex((byte[])data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }
}

