/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.Properties;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.MessageUtil;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;

public class RocketmqProducer {
    RocketmqConfig cfg;
    DefaultMQProducer producer;

    public RocketmqProducer(RocketmqConfig config) {
        this.cfg = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(CloudProps cloudProps) throws MQClientException {
        if (this.producer != null) {
            return;
        }
        RocketmqProducer rocketmqProducer = this;
        synchronized (rocketmqProducer) {
            if (this.producer != null) {
                return;
            }
            this.producer = new DefaultMQProducer();
            this.producer.setNamesrvAddr(this.cfg.getServer());
            this.producer.setProducerGroup(this.cfg.getProducerGroup());
            if (Utils.isNotEmpty((String)this.cfg.getNamespace())) {
                this.producer.setNamespace(this.cfg.getNamespace());
            }
            if (this.cfg.getTimeout() > 0L) {
                this.producer.setSendMsgTimeout((int)this.cfg.getTimeout());
            }
            this.producer.setRetryTimesWhenSendFailed(2);
            Properties props = cloudProps.getEventProducerProps();
            if (props.size() > 0) {
                Utils.injectProperties((Object)this.producer, (Properties)props);
            }
            this.producer.start();
        }
    }

    public boolean publish(CloudProps cloudProps, Event event, String topic) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.init(cloudProps);
        Message message = MessageUtil.buildNewMeaage(event, topic);
        SendResult send = this.producer.send(message);
        return send.getSendStatus().equals((Object)SendStatus.SEND_OK);
    }
}

