/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.Properties;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.service.CloudEventObserverManger;

public class RocketmqConsumer {
    private RocketmqConfig cfg;
    private DefaultMQPushConsumer consumer;
    private RocketmqConsumerHandler handler;

    public RocketmqConsumer(RocketmqConfig config) {
        this.cfg = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CloudProps cloudProps, CloudEventObserverManger observerManger) {
        if (this.consumer != null) {
            return;
        }
        RocketmqConsumer rocketmqConsumer = this;
        synchronized (rocketmqConsumer) {
            if (this.consumer != null) {
                return;
            }
            this.handler = new RocketmqConsumerHandler(cloudProps, observerManger);
            this.consumer = new DefaultMQPushConsumer();
            this.consumer.setNamesrvAddr(this.cfg.getServer());
            this.consumer.setConsumerGroup(this.cfg.getConsumerGroup());
            if (Utils.isNotEmpty((String)this.cfg.getNamespace())) {
                this.consumer.setNamespace(this.cfg.getNamespace());
            }
            this.consumer.setConsumeMessageBatchMaxSize(1);
            this.consumer.setPullBatchSize(32);
            Properties props = cloudProps.getEventConsumerProps();
            if (props.size() > 0) {
                Utils.injectProperties((Object)this.consumer, (Properties)props);
            }
            try {
                for (String topic : observerManger.topicAll()) {
                    this.consumer.subscribe(topic, "*");
                }
                this.consumer.registerMessageListener((MessageListenerConcurrently)this.handler);
                this.consumer.start();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

