/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumerHandler
implements MessageListenerConcurrently {
    static final Logger log = LoggerFactory.getLogger(RocketmqConsumerHandler.class);
    private final CloudEventObserverManger observerManger;
    private final RocketmqConfig config;

    public RocketmqConsumerHandler(RocketmqConfig config, CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
        this.config = config;
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> list, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        boolean isOk = true;
        try {
            for (MessageExt message : list) {
                String topicNew = message.getTopic();
                String group = null;
                String topic = null;
                if (topicNew.contains("--")) {
                    group = topicNew.split("--")[0];
                    topic = topicNew.split("--")[1];
                } else {
                    topic = topicNew;
                }
                Event event = new Event(topic, new String(message.getBody()));
                event.tags(message.getTags());
                event.key(message.getKeys());
                event.times(message.getReconsumeTimes());
                event.channel(this.config.getChannelName());
                if (Utils.isNotEmpty((String)group)) {
                    event.group(group);
                }
                isOk = isOk && this.onReceive(event, topicNew);
            }
        }
        catch (Throwable e) {
            isOk = false;
            log.warn(e.getMessage(), e);
        }
        if (isOk) {
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
    }

    protected boolean onReceive(Event event, String topicNew) throws Throwable {
        boolean isOk = true;
        EventObserver handler = null;
        if (Utils.isEmpty((String)event.tags())) {
            handler = this.observerManger.getByTopicAndTag(topicNew, "*");
        } else {
            handler = this.observerManger.getByTopicAndTag(topicNew, event.tags());
            if (handler == null) {
                handler = this.observerManger.getByTopicAndTag(topicNew, "*");
            }
        }
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

