/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConfig {
    static final Logger log = LoggerFactory.getLogger(RocketmqConfig.class);
    private static final String PROP_EVENT_consumerGroup = "event.consumerGroup";
    private static final String PROP_EVENT_producerGroup = "event.producerGroup";
    private static final String PROP_EVENT_consumeThreadNums = "event.consumeThreadNums";
    private static final String PROP_EVENT_maxReconsumeTimes = "event.maxReconsumeTimes";
    private String producerGroup;
    private String consumerGroup;
    private final String channelName;
    private final String server;
    private final String namespace;
    private final String accessKey;
    private final String secretKey;
    private final long timeout;
    private final int consumeThreadNums;
    private final int maxReconsumeTimes;

    public RocketmqConfig(CloudProps cloudProps) {
        this.server = cloudProps.getEventServer();
        this.channelName = cloudProps.getEventChannel();
        this.namespace = cloudProps.getNamespace();
        this.accessKey = cloudProps.getEventAccessKey();
        this.secretKey = cloudProps.getEventSecretKey();
        this.timeout = cloudProps.getEventPublishTimeout();
        this.consumeThreadNums = Integer.valueOf(cloudProps.getValue(PROP_EVENT_consumeThreadNums, "0"));
        this.maxReconsumeTimes = Integer.valueOf(cloudProps.getValue(PROP_EVENT_maxReconsumeTimes, "0"));
        this.producerGroup = cloudProps.getValue(PROP_EVENT_producerGroup);
        this.consumerGroup = cloudProps.getValue(PROP_EVENT_consumerGroup);
        if (Utils.isEmpty((String)this.producerGroup)) {
            this.producerGroup = "DEFAULT";
        }
        if (Utils.isEmpty((String)this.consumerGroup)) {
            this.consumerGroup = Solon.cfg().appGroup() + "_" + Solon.cfg().appName();
        }
        log.trace("producerGroup=" + this.producerGroup);
        log.trace("consumerGroup=" + this.consumerGroup);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getServer() {
        return this.server;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getConsumeThreadNums() {
        return this.consumeThreadNums;
    }

    public int getMaxReconsumeTimes() {
        return this.maxReconsumeTimes;
    }
}

