/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.rocketmq.common.message.Message;
import org.noear.solon.Utils;
import org.noear.solon.cloud.model.Event;

class MessageUtil {
    MessageUtil() {
    }

    public static Message buildNewMeaage(Event event, String topic) {
        String topicNew = topic.replace(".", "_");
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        Message message = new Message(topicNew, event.tags(), event.key(), event.content().getBytes(StandardCharsets.UTF_8));
        message.putUserProperty("__CREATED_TIMESTAMP", String.valueOf(event.created()));
        for (Map.Entry kv : event.meta().entrySet()) {
            message.putUserProperty("!" + (String)kv.getKey(), (String)kv.getValue());
        }
        if (event.scheduled() != null) {
            long delaySeconds = (event.scheduled().getTime() - System.currentTimeMillis()) / 1000L;
            double delayHours = delaySeconds / 60L / 60L;
            if (delaySeconds > 0L) {
                if (delayHours > 2.0) {
                    throw new IllegalArgumentException("RocketMQ does not support a delay longer than 2 hours");
                }
                if (delaySeconds < 5L) {
                    message.setDelayTimeLevel(1);
                } else if (delaySeconds < 10L) {
                    message.setDelayTimeLevel(2);
                } else if (delaySeconds < 30L) {
                    message.setDelayTimeLevel(3);
                } else if (delaySeconds < 60L) {
                    message.setDelayTimeLevel(4);
                } else if (delaySeconds < 120L) {
                    message.setDelayTimeLevel(5);
                } else if (delaySeconds < 180L) {
                    message.setDelayTimeLevel(6);
                } else if (delaySeconds < 240L) {
                    message.setDelayTimeLevel(7);
                } else if (delaySeconds < 300L) {
                    message.setDelayTimeLevel(8);
                } else if (delaySeconds < 360L) {
                    message.setDelayTimeLevel(9);
                } else if (delaySeconds < 420L) {
                    message.setDelayTimeLevel(10);
                } else if (delaySeconds < 480L) {
                    message.setDelayTimeLevel(11);
                } else if (delaySeconds < 540L) {
                    message.setDelayTimeLevel(12);
                } else if (delaySeconds < 600L) {
                    message.setDelayTimeLevel(13);
                } else if (delaySeconds < 1200L) {
                    message.setDelayTimeLevel(14);
                } else if (delaySeconds < 1800L) {
                    message.setDelayTimeLevel(15);
                } else if (delaySeconds < 3600L) {
                    message.setDelayTimeLevel(16);
                } else if (delaySeconds < 7200L) {
                    message.setDelayTimeLevel(17);
                } else {
                    message.setDelayTimeLevel(18);
                }
            }
        }
        return message;
    }
}

