/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;
import org.noear.solon.Utils;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.model.EventObserverMap;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumer
implements Closeable {
    static Logger log = LoggerFactory.getLogger(RocketmqConsumer.class);
    private RocketmqConfig config;
    private DefaultMQPushConsumer consumerOfCluster;
    private DefaultMQPushConsumer consumerOfInstance;

    public RocketmqConsumer(RocketmqConfig config) {
        this.config = config;
    }

    public void init(CloudEventObserverManger observerManger) throws MQClientException {
        if (this.consumerOfCluster != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.consumerOfCluster != null) {
                return;
            }
            String instanceName = Instance.local().serviceAndAddress().replace("@", "-").replace(".", "_").replace(":", "_");
            this.consumerOfCluster = this.buildConsumer(observerManger, this.config.getConsumerGroup(), EventLevel.cluster);
            this.consumerOfInstance = this.buildConsumer(observerManger, instanceName, EventLevel.instance);
            log.trace("Rocketmq consumer started!");
        }
        finally {
            Utils.locker().unlock();
        }
    }

    private DefaultMQPushConsumer buildConsumer(CloudEventObserverManger observerManger, String consumerGroup, EventLevel eventLevel) throws MQClientException {
        DefaultMQPushConsumer consumer;
        if (Utils.isEmpty((String)this.config.getAccessKey())) {
            consumer = new DefaultMQPushConsumer();
        } else {
            AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(this.config.getAccessKey(), this.config.getSecretKey()));
            consumer = new DefaultMQPushConsumer((RPCHook)rpcHook);
        }
        consumer.setNamesrvAddr(this.config.getServer());
        consumer.setConsumerGroup(consumerGroup);
        if (Utils.isNotEmpty((String)this.config.getNamespace())) {
            consumer.setNamespace(this.config.getNamespace());
        }
        if (this.config.getConsumeThreadNums() > 0) {
            consumer.setConsumeThreadMax(this.config.getConsumeThreadNums());
        }
        if (this.config.getMaxReconsumeTimes() > 0) {
            consumer.setMaxReconsumeTimes(this.config.getMaxReconsumeTimes());
        }
        consumer.setConsumeMessageBatchMaxSize(1);
        consumer.setPullBatchSize(32);
        Properties props = this.config.getCloudProps().getEventConsumerProps();
        if (props.size() > 0) {
            Utils.injectProperties((Object)consumer, (Properties)props);
        }
        boolean isOk = false;
        for (String topic : observerManger.topicAll()) {
            EventObserverMap tagsObserverMap = observerManger.topicOf(topic);
            Collection tags = tagsObserverMap.getTagsByLevel(eventLevel);
            if (tags.size() <= 0) continue;
            String tagsExpr = String.join((CharSequence)"||", tags);
            if (tags.contains("*")) {
                consumer.subscribe(topic, "*");
            } else {
                consumer.subscribe(topic, tagsExpr);
            }
            isOk = true;
            log.trace("Rocketmq consumer subscribe [" + topic + "(" + tagsExpr + ")] ok!");
        }
        if (!isOk) {
            return null;
        }
        consumer.registerMessageListener((MessageListenerConcurrently)new RocketmqConsumerHandler(this.config, observerManger));
        consumer.start();
        return consumer;
    }

    @Override
    public void close() throws IOException {
        if (this.consumerOfCluster != null) {
            this.consumerOfCluster.shutdown();
        }
        if (this.consumerOfInstance != null) {
            this.consumerOfInstance.shutdown();
        }
    }
}

