/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.rocketmq.impl.MessageUtil;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;

public class RocketmqProducer
implements Closeable {
    private final RocketmqConfig config;
    private DefaultMQProducer producer;

    public RocketmqProducer(RocketmqConfig config) {
        this.config = config;
    }

    private void lazyInit() throws MQClientException {
        if (this.producer != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.producer != null) {
                return;
            }
            if (Utils.isEmpty((String)this.config.getAccessKey())) {
                this.producer = new DefaultMQProducer();
            } else {
                AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(this.config.getAccessKey(), this.config.getSecretKey()));
                this.producer = new DefaultMQProducer((RPCHook)rpcHook);
            }
            this.producer.setNamesrvAddr(this.config.getServer());
            this.producer.setProducerGroup(this.config.getProducerGroup());
            if (Utils.isNotEmpty((String)this.config.getNamespace())) {
                this.producer.setNamespace(this.config.getNamespace());
            }
            if (this.config.getTimeout() > 0L) {
                this.producer.setSendMsgTimeout((int)this.config.getTimeout());
            }
            this.producer.setRetryTimesWhenSendFailed(2);
            Properties props = this.config.getCloudProps().getEventProducerProps();
            if (props.size() > 0) {
                Utils.injectProperties((Object)this.producer, (Properties)props);
            }
            this.producer.start();
        }
        finally {
            Utils.locker().unlock();
        }
    }

    public boolean publish(Event event, String topic) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.lazyInit();
        Message message = MessageUtil.buildNewMeaage(event, topic);
        SendResult send = this.producer.send(message);
        return send.getSendStatus().equals((Object)SendStatus.SEND_OK);
    }

    @Override
    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.shutdown();
        }
    }
}

