/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.noear.solon.cloud.extend.rocketmq.RocketmqProps;
import org.noear.solon.cloud.extend.rocketmq.impl.MessageUtil;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;

public class RocketmqProducer {
    RocketmqConfig cfg;
    int timeout;
    DefaultMQProducer producer;

    public RocketmqProducer(RocketmqConfig config) {
        this.cfg = config;
        this.timeout = RocketmqProps.instance.getEventPublishTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.producer != null) {
            return;
        }
        RocketmqProducer rocketmqProducer = this;
        synchronized (rocketmqProducer) {
            if (this.producer != null) {
                return;
            }
            this.producer = new DefaultMQProducer(this.cfg.exchangeName);
            this.producer.setNamesrvAddr(this.cfg.server);
            if (this.timeout > 0) {
                this.producer.setSendMsgTimeout(this.timeout);
            }
            this.producer.setRetryTimesWhenSendFailed(2);
            try {
                this.producer.start();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public boolean publish(Event event) {
        this.init();
        try {
            Message message = MessageUtil.buildNewMeaage(event);
            SendResult send = this.producer.send(message);
            return send.getSendStatus().equals((Object)SendStatus.SEND_OK);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

