/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.service;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.rocketmq.RocketmqProps;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumer;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverEntity;
import org.noear.solon.cloud.service.CloudEventService;

public class CloudEventServiceRocketmqImp
implements CloudEventService {
    private static CloudEventServiceRocketmqImp instance;
    RocketmqProducer producer;
    RocketmqConsumer consumer;
    Map<String, CloudEventObserverEntity> observerMap = new HashMap<String, CloudEventObserverEntity>();

    public static synchronized CloudEventServiceRocketmqImp getInstance() {
        if (instance == null) {
            instance = new CloudEventServiceRocketmqImp();
        }
        return instance;
    }

    private CloudEventServiceRocketmqImp() {
        RocketmqConfig config = new RocketmqConfig();
        config.server = RocketmqProps.instance.getEventServer();
        this.producer = new RocketmqProducer(config);
        this.consumer = new RocketmqConsumer(config);
    }

    public boolean publish(Event event) {
        return this.producer.publish(event);
    }

    public void attention(EventLevel level, String channel, String group, String topic, CloudEventHandler observer) {
        if (this.observerMap.containsKey(topic)) {
            return;
        }
        topic = topic.replace(".", "_");
        this.observerMap.put(topic, new CloudEventObserverEntity(level, group, topic, observer));
    }

    public void subscribe() {
        if (this.observerMap.size() > 0) {
            this.consumer.init(this.observerMap);
        }
    }
}

