/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.noear.solon.cloud.extend.rocketmq.RocketmqProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverEntity;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.ext.WarnThrowable;

public class RocketmqConsumerHandler
implements MessageListenerConcurrently {
    Map<String, CloudEventObserverEntity> observerMap;
    String eventChannelName;

    public RocketmqConsumerHandler(Map<String, CloudEventObserverEntity> observers) {
        this.observerMap = observers;
        this.eventChannelName = RocketmqProps.instance.getEventChannel();
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> list, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        boolean isOk = true;
        try {
            for (MessageExt message : list) {
                Event event = new Event(message.getTopic(), new String(message.getBody()));
                event.tags(message.getTags());
                event.key(message.getKeys());
                event.times(message.getReconsumeTimes());
                event.channel(this.eventChannelName);
                isOk = isOk && this.onReceive(event);
            }
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
        if (isOk) {
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
    }

    public boolean onReceive(Event event) throws Throwable {
        boolean isOk = true;
        CloudEventObserverEntity entity = null;
        entity = this.observerMap.get(event.topic());
        if (entity != null) {
            isOk = entity.handler(event);
        } else {
            EventBus.push((Object)new WarnThrowable((Object)event, "There is no observer for this event topic[" + event.topic() + "]"));
        }
        return isOk;
    }
}

