/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.noear.solon.cloud.extend.rocketmq.RocketmqProps;
import org.noear.solon.cloud.extend.rocketmq.impl.MessageUtil;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;

public class RocketmqProducer {
    RocketmqConfig cfg;
    long timeout;
    DefaultMQProducer producer;

    public RocketmqProducer(RocketmqConfig config) {
        this.cfg = config;
        this.timeout = RocketmqProps.instance.getEventPublishTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws MQClientException {
        if (this.producer != null) {
            return;
        }
        RocketmqProducer rocketmqProducer = this;
        synchronized (rocketmqProducer) {
            if (this.producer != null) {
                return;
            }
            this.producer = new DefaultMQProducer(this.cfg.exchangeName);
            this.producer.setNamesrvAddr(this.cfg.server);
            if (this.timeout > 0L) {
                this.producer.setSendMsgTimeout((int)this.timeout);
            }
            this.producer.setRetryTimesWhenSendFailed(2);
            this.producer.start();
        }
    }

    public boolean publish(Event event) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.init();
        Message message = MessageUtil.buildNewMeaage(event);
        SendResult send = this.producer.send(message);
        return send.getSendStatus().equals((Object)SendStatus.SEND_OK);
    }
}

