/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.Map;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.service.CloudEventObserverEntity;

public class RocketmqConsumer {
    RocketmqConfig cfg;
    DefaultMQPushConsumer consumer;
    RocketmqConsumerHandler handler;
    Map<String, CloudEventObserverEntity> observerMap;

    public RocketmqConsumer(RocketmqConfig config) {
        this.cfg = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map<String, CloudEventObserverEntity> observers) {
        if (this.consumer != null) {
            return;
        }
        RocketmqConsumer rocketmqConsumer = this;
        synchronized (rocketmqConsumer) {
            if (this.consumer != null) {
                return;
            }
            this.observerMap = observers;
            this.handler = new RocketmqConsumerHandler(this.observerMap);
            this.consumer = new DefaultMQPushConsumer(this.cfg.exchangeName);
            this.consumer.setNamesrvAddr(this.cfg.server);
            this.consumer.setPullBatchSize(1);
            this.consumer.setConsumerGroup(this.cfg.queueName);
            try {
                for (String topic : this.observerMap.keySet()) {
                    this.consumer.subscribe(topic, "*");
                }
                this.consumer.registerMessageListener((MessageListenerConcurrently)this.handler);
                this.consumer.start();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

