/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.Properties;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.rocketmq.RocketmqProps;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.service.CloudEventObserverManger;

public class RocketmqConsumer {
    RocketmqConfig cfg;
    DefaultMQPushConsumer consumer;
    RocketmqConsumerHandler handler;

    public RocketmqConsumer(RocketmqConfig config) {
        this.cfg = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CloudEventObserverManger observerManger) {
        if (this.consumer != null) {
            return;
        }
        RocketmqConsumer rocketmqConsumer = this;
        synchronized (rocketmqConsumer) {
            if (this.consumer != null) {
                return;
            }
            this.handler = new RocketmqConsumerHandler(observerManger);
            this.consumer = new DefaultMQPushConsumer();
            this.consumer.setNamesrvAddr(this.cfg.server);
            this.consumer.setConsumerGroup(this.cfg.consumerGroup);
            if (Utils.isNotEmpty((String)this.cfg.namespace)) {
                this.consumer.setNamespace(this.cfg.namespace);
            }
            this.consumer.setConsumeMessageBatchMaxSize(1);
            this.consumer.setPullBatchSize(32);
            Properties props = RocketmqProps.instance.getEventConsumerProps();
            if (props.size() > 0) {
                Utils.injectProperties((Object)this.consumer, (Properties)props);
            }
            try {
                for (String topic : observerManger.topicAll()) {
                    this.consumer.subscribe(topic, "*");
                }
                this.consumer.registerMessageListener((MessageListenerConcurrently)this.handler);
                this.consumer.start();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

