/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.rocketmq.RocketmqProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumerHandler
implements MessageListenerConcurrently {
    static Logger log = LoggerFactory.getLogger(RocketmqConsumerHandler.class);
    CloudEventObserverManger observerManger;
    String eventChannelName;

    public RocketmqConsumerHandler(CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
        this.eventChannelName = RocketmqProps.instance.getEventChannel();
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> list, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        boolean isOk = true;
        try {
            for (MessageExt message : list) {
                String topicNew = message.getTopic();
                String group = null;
                String topic = null;
                if (topicNew.contains("--")) {
                    group = topicNew.split("--")[0];
                    topic = topicNew.split("--")[1];
                } else {
                    topic = topicNew;
                }
                Event event = new Event(topic, new String(message.getBody()));
                event.tags(message.getTags());
                event.key(message.getKeys());
                event.times(message.getReconsumeTimes());
                event.channel(this.eventChannelName);
                if (Utils.isNotEmpty((String)group)) {
                    event.group(group);
                }
                isOk = isOk && this.onReceive(event, topicNew);
            }
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
        if (isOk) {
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
    }

    protected boolean onReceive(Event event, String topicNew) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        handler = this.observerManger.get(topicNew);
        if (handler != null) {
            isOk = handler.handler(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

