/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;

public class RocketmqConfig {
    private CloudProps cloudProps;
    protected String producerGroup;
    protected String consumerGroup;
    protected String server;
    protected String namespace;
    protected long timeout;

    public RocketmqConfig(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        this.server = cloudProps.getEventServer();
        this.timeout = cloudProps.getEventPublishTimeout();
        this.namespace = this.getEventNamespace();
        this.producerGroup = this.getEventProducerGroup();
        this.consumerGroup = this.getEventConsumerGroup();
        if (Utils.isEmpty((String)this.producerGroup)) {
            this.producerGroup = "DEFAULT";
        }
        if (Utils.isEmpty((String)this.consumerGroup)) {
            this.consumerGroup = Solon.cfg().appGroup() + "_" + Solon.cfg().appName();
        }
    }

    public String getEventNamespace() {
        return this.cloudProps.getProp("event.namespace");
    }

    public String getEventConsumerGroup() {
        return this.cloudProps.getProp("event.consumerGroup");
    }

    public String getEventProducerGroup() {
        return this.cloudProps.getProp("event.producerGroup");
    }
}

