/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.service;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumer;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;

public class CloudEventServiceRocketmqImp
implements CloudEventServicePlus {
    private CloudProps cloudProps;
    private RocketmqProducer producer;
    private RocketmqConsumer consumer;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServiceRocketmqImp(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        RocketmqConfig config = new RocketmqConfig(cloudProps);
        this.producer = new RocketmqProducer(config);
        this.consumer = new RocketmqConsumer(config);
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + "--" + event.topic();
        topicNew = topicNew.replace(".", "_");
        try {
            return this.producer.publish(this.cloudProps, event, topicNew);
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, CloudEventHandler observer) {
        topic = topic.replace(".", "_");
        String topicNew = Utils.isEmpty((String)group) ? topic : group + "--" + topic;
        this.observerManger.add(topicNew, level, group, topic, observer);
    }

    public void subscribe() {
        if (this.observerManger.topicSize() > 0) {
            this.consumer.init(this.cloudProps, this.observerManger);
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }
}

