/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;

public class RocketmqConfig {
    private String producerGroup;
    private String consumerGroup;
    private String server;
    private String namespace;
    private long timeout;

    public RocketmqConfig(CloudProps cloudProps) {
        this.server = cloudProps.getEventServer();
        this.timeout = cloudProps.getEventPublishTimeout();
        this.namespace = Solon.cfg().appNamespace();
        this.producerGroup = cloudProps.getValue("event.producerGroup");
        this.consumerGroup = cloudProps.getValue("event.consumerGroup");
        if (Utils.isEmpty((String)this.producerGroup)) {
            this.producerGroup = "DEFAULT";
        }
        if (Utils.isEmpty((String)this.consumerGroup)) {
            this.consumerGroup = Solon.cfg().appGroup() + "_" + Solon.cfg().appName();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public String getServer() {
        return this.server;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

