/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumerHandler
implements MessageListener {
    static Logger log = LoggerFactory.getLogger(RocketmqConsumerHandler.class);
    CloudEventObserverManger observerManger;
    String eventChannelName;

    public RocketmqConsumerHandler(CloudProps cloudProps, CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
        this.eventChannelName = cloudProps.getEventChannel();
    }

    public ConsumeResult consume(MessageView message) {
        boolean isOk = true;
        try {
            String topicNew = message.getTopic();
            String group = null;
            String topic = null;
            if (topicNew.contains("--")) {
                group = topicNew.split("--")[0];
                topic = topicNew.split("--")[1];
            } else {
                topic = topicNew;
            }
            Event event = new Event(topic, new String(message.getBody().array()));
            event.tags((String)message.getTag().get());
            event.key(String.join((CharSequence)",", message.getKeys()));
            event.channel(this.eventChannelName);
            if (Utils.isNotEmpty((String)group)) {
                event.group(group);
            }
            isOk = isOk && this.onReceive(event, topicNew);
        }
        catch (Throwable ex) {
            isOk = false;
            EventBus.push((Object)ex);
        }
        if (isOk) {
            return ConsumeResult.SUCCESS;
        }
        return ConsumeResult.FAILURE;
    }

    protected boolean onReceive(Event event, String topicNew) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        handler = this.observerManger.get(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

