/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.time.Duration;
import java.util.LinkedHashMap;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.PushConsumerBuilder;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.service.CloudEventObserverManger;

public class RocketmqConsumer {
    private RocketmqConfig cfg;
    ClientServiceProvider serviceProvider;
    private PushConsumer consumer;
    private RocketmqConsumerHandler handler;

    public RocketmqConsumer(RocketmqConfig config) {
        this.cfg = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CloudProps cloudProps, CloudEventObserverManger observerManger) throws ClientException {
        if (this.consumer != null) {
            return;
        }
        RocketmqConsumer rocketmqConsumer = this;
        synchronized (rocketmqConsumer) {
            if (this.consumer != null) {
                return;
            }
            this.handler = new RocketmqConsumerHandler(cloudProps, observerManger);
            this.serviceProvider = ClientServiceProvider.loadService();
            ClientConfigurationBuilder builder = ClientConfiguration.newBuilder();
            builder.setEndpoints(this.cfg.getServer());
            if (this.cfg.getTimeout() > 0L) {
                builder.setRequestTimeout(Duration.ofMillis(this.cfg.getTimeout()));
            }
            ClientConfiguration configuration = builder.build();
            LinkedHashMap<String, FilterExpression> subscriptionExpressions = new LinkedHashMap<String, FilterExpression>();
            for (String topic : observerManger.topicAll()) {
                subscriptionExpressions.put(topic, FilterExpression.SUB_ALL);
            }
            PushConsumerBuilder consumerBuilder = this.serviceProvider.newPushConsumerBuilder().setClientConfiguration(configuration).setConsumerGroup(this.cfg.getConsumerGroup()).setSubscriptionExpressions(subscriptionExpressions).setMessageListener((MessageListener)this.handler);
            this.consumer = consumerBuilder.build();
        }
    }
}

