/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.time.Duration;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.MessageUtil;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;

public class RocketmqProducer {
    RocketmqConfig cfg;
    ClientServiceProvider serviceProvider;
    Producer producer;

    public RocketmqProducer(RocketmqConfig config) {
        this.cfg = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(CloudProps cloudProps) throws ClientException {
        if (this.producer != null) {
            return;
        }
        RocketmqProducer rocketmqProducer = this;
        synchronized (rocketmqProducer) {
            if (this.producer != null) {
                return;
            }
            this.serviceProvider = ClientServiceProvider.loadService();
            ClientConfigurationBuilder builder = ClientConfiguration.newBuilder();
            builder.setEndpoints(this.cfg.getServer());
            if (this.cfg.getTimeout() > 0L) {
                builder.setRequestTimeout(Duration.ofMillis(this.cfg.getTimeout()));
            }
            ClientConfiguration configuration = builder.build();
            this.producer = this.serviceProvider.newProducerBuilder().setClientConfiguration(configuration).build();
        }
    }

    public boolean publish(CloudProps cloudProps, Event event, String topic) throws ClientException {
        this.init(cloudProps);
        Message message = MessageUtil.buildNewMeaage(this.serviceProvider, event, topic);
        SendReceipt sendReceipt = this.producer.send(message);
        return sendReceipt != null;
    }
}

