/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.PushConsumerBuilder;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.service.CloudEventObserverManger;

public class RocketmqConsumer {
    private RocketmqConfig config;
    ClientServiceProvider serviceProvider;
    private PushConsumer consumer;
    private RocketmqConsumerHandler handler;

    public RocketmqConsumer(RocketmqConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CloudProps cloudProps, CloudEventObserverManger observerManger) throws ClientException {
        if (this.consumer != null) {
            return;
        }
        RocketmqConsumer rocketmqConsumer = this;
        synchronized (rocketmqConsumer) {
            if (this.consumer != null) {
                return;
            }
            this.handler = new RocketmqConsumerHandler(this.config, observerManger);
            this.serviceProvider = ClientServiceProvider.loadService();
            ClientConfigurationBuilder builder = ClientConfiguration.newBuilder();
            builder.setEndpoints(this.config.getServer());
            if (this.config.getTimeout() > 0L) {
                builder.setRequestTimeout(Duration.ofMillis(this.config.getTimeout()));
            }
            ClientConfiguration configuration = builder.build();
            LinkedHashMap<String, FilterExpression> subscriptionExpressions = new LinkedHashMap<String, FilterExpression>();
            for (Map.Entry kv : observerManger.topicTags().entrySet()) {
                String topic = (String)kv.getKey();
                Set tags = (Set)kv.getValue();
                if (tags.contains("*")) {
                    subscriptionExpressions.put(topic, FilterExpression.SUB_ALL);
                    continue;
                }
                subscriptionExpressions.put(topic, new FilterExpression(String.join((CharSequence)"||", tags)));
            }
            PushConsumerBuilder consumerBuilder = this.serviceProvider.newPushConsumerBuilder().setClientConfiguration(configuration).setConsumerGroup(this.config.getConsumerGroup()).setConsumptionThreadCount(this.config.getConsumeThreadNums()).setSubscriptionExpressions(subscriptionExpressions).setMessageListener((MessageListener)this.handler);
            this.consumer = consumerBuilder.build();
        }
    }
}

