/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumerHandler
implements MessageListener {
    static Logger log = LoggerFactory.getLogger(RocketmqConsumerHandler.class);
    private final CloudEventObserverManger observerManger;
    private final RocketmqConfig config;

    public RocketmqConsumerHandler(RocketmqConfig config, CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
        this.config = config;
    }

    public ConsumeResult consume(MessageView message) {
        boolean isOk = true;
        try {
            String topicNew = message.getTopic();
            String group = null;
            String topic = null;
            if (topicNew.contains("--")) {
                group = topicNew.split("--")[0];
                topic = topicNew.split("--")[1];
            } else {
                topic = topicNew;
            }
            String content = StandardCharsets.UTF_8.decode(message.getBody()).toString();
            Event event = new Event(topic, content);
            event.tags((String)message.getTag().orElse(null));
            event.key(String.join((CharSequence)",", message.getKeys()));
            event.times(message.getDeliveryAttempt() - 1);
            event.channel(this.config.getChannelName());
            if (Utils.isNotEmpty((String)group)) {
                event.group(group);
            }
            isOk = isOk && this.onReceive(event, topicNew);
        }
        catch (Throwable e) {
            isOk = false;
            EventBus.pushTry((Object)e);
        }
        if (isOk) {
            return ConsumeResult.SUCCESS;
        }
        return ConsumeResult.FAILURE;
    }

    protected boolean onReceive(Event event, String topicNew) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        if (Utils.isEmpty((String)event.tags())) {
            handler = this.observerManger.getByTopicAndTag(topicNew, "*");
        } else {
            handler = this.observerManger.getByTopicAndTag(topicNew, event.tags());
            if (handler == null) {
                handler = this.observerManger.getByTopicAndTag(topicNew, "*");
            }
        }
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

