/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.MessageUtil;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;

public class RocketmqProducer
implements Closeable {
    RocketmqConfig config;
    ClientServiceProvider serviceProvider;
    Producer producer;

    public RocketmqProducer(RocketmqConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(CloudProps cloudProps) throws ClientException {
        if (this.producer != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.producer != null) {
                return;
            }
            this.serviceProvider = ClientServiceProvider.loadService();
            ClientConfigurationBuilder builder = ClientConfiguration.newBuilder();
            builder.setEndpoints(this.config.getServer());
            if (Utils.isNotEmpty((String)this.config.getAccessKey())) {
                builder.setCredentialProvider((SessionCredentialsProvider)new StaticSessionCredentialsProvider(this.config.getAccessKey(), this.config.getSecretKey()));
            }
            if (this.config.getTimeout() > 0L) {
                builder.setRequestTimeout(Duration.ofMillis(this.config.getTimeout()));
            }
            ClientConfiguration configuration = builder.build();
            this.producer = this.serviceProvider.newProducerBuilder().setClientConfiguration(configuration).build();
        }
        finally {
            Utils.locker().unlock();
        }
    }

    public boolean publish(CloudProps cloudProps, Event event, String topic) throws ClientException {
        this.init(cloudProps);
        Message message = MessageUtil.buildNewMeaage(this.serviceProvider, event, topic);
        SendReceipt sendReceipt = this.producer.send(message);
        return sendReceipt != null;
    }

    @Override
    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

