/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.PushConsumerBuilder;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumer
implements Closeable {
    static Logger log = LoggerFactory.getLogger(RocketmqConsumer.class);
    private RocketmqConfig config;
    ClientServiceProvider serviceProvider;
    private PushConsumer consumer;
    private RocketmqConsumerHandler handler;

    public RocketmqConsumer(RocketmqConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CloudProps cloudProps, CloudEventObserverManger observerManger) throws ClientException {
        if (this.consumer != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.consumer != null) {
                return;
            }
            this.serviceProvider = ClientServiceProvider.loadService();
            ClientConfigurationBuilder builder = ClientConfiguration.newBuilder();
            builder.setEndpoints(this.config.getServer());
            if (Utils.isNotEmpty((String)this.config.getAccessKey())) {
                builder.setCredentialProvider((SessionCredentialsProvider)new StaticSessionCredentialsProvider(this.config.getAccessKey(), this.config.getSecretKey()));
            }
            if (this.config.getTimeout() > 0L) {
                builder.setRequestTimeout(Duration.ofMillis(this.config.getTimeout()));
            }
            ClientConfiguration configuration = builder.build();
            LinkedHashMap<String, FilterExpression> subscriptionExpressions = new LinkedHashMap<String, FilterExpression>();
            for (Map.Entry kv : observerManger.topicTags().entrySet()) {
                String topic = (String)kv.getKey();
                Set tags = (Set)kv.getValue();
                String tagsExpr = String.join((CharSequence)"||", tags);
                if (tags.contains("*")) {
                    subscriptionExpressions.put(topic, FilterExpression.SUB_ALL);
                } else {
                    subscriptionExpressions.put(topic, new FilterExpression(tagsExpr));
                }
                log.trace("Rocketmq5 consumer subscribe [" + topic + "(" + tagsExpr + ")] ok!");
            }
            PushConsumerBuilder consumerBuilder = this.serviceProvider.newPushConsumerBuilder();
            consumerBuilder.setClientConfiguration(configuration);
            consumerBuilder.setConsumerGroup(this.config.getConsumerGroup());
            this.handler = new RocketmqConsumerHandler(this.config, observerManger);
            consumerBuilder.setMessageListener((MessageListener)this.handler);
            if (subscriptionExpressions.size() > 0) {
                consumerBuilder.setSubscriptionExpressions(subscriptionExpressions);
            }
            if (this.config.getConsumeThreadNums() > 0) {
                consumerBuilder.setConsumptionThreadCount(this.config.getConsumeThreadNums());
            }
            this.consumer = consumerBuilder.build();
            log.trace("Rocketmq5 consumer started!");
        }
        finally {
            Utils.locker().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }
}

