/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientConfigurationBuilder;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.PushConsumerBuilder;
import org.noear.solon.Utils;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.model.EventObserverMap;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqConsumer
implements Closeable {
    static Logger log = LoggerFactory.getLogger(RocketmqConsumer.class);
    private RocketmqConfig config;
    private ClientServiceProvider serviceProvider;
    private PushConsumer consumerOfCluster;
    private PushConsumer consumerOfInstance;

    public RocketmqConsumer(RocketmqConfig config) {
        this.config = config;
        this.serviceProvider = ClientServiceProvider.loadService();
    }

    public void init(CloudEventObserverManger observerManger) throws ClientException {
        if (this.consumerOfCluster != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.consumerOfCluster != null) {
                return;
            }
            this.consumerOfCluster = this.buildConsumer(observerManger, this.config.getConsumerGroup(), EventLevel.cluster);
            this.consumerOfInstance = this.buildConsumer(observerManger, Instance.local().serviceAndAddress(), EventLevel.instance);
            log.trace("Rocketmq5 consumer started!");
        }
        finally {
            Utils.locker().unlock();
        }
    }

    private PushConsumer buildConsumer(CloudEventObserverManger observerManger, String consumerGroup, EventLevel eventLevel) throws ClientException {
        ClientConfigurationBuilder builder = ClientConfiguration.newBuilder();
        builder.setEndpoints(this.config.getServer());
        if (Utils.isNotEmpty((String)this.config.getAccessKey())) {
            builder.setCredentialProvider((SessionCredentialsProvider)new StaticSessionCredentialsProvider(this.config.getAccessKey(), this.config.getSecretKey()));
        }
        if (this.config.getTimeout() > 0L) {
            builder.setRequestTimeout(Duration.ofMillis(this.config.getTimeout()));
        }
        ClientConfiguration configuration = builder.build();
        LinkedHashMap<String, FilterExpression> subscriptionExpressions = new LinkedHashMap<String, FilterExpression>();
        for (String topic : observerManger.topicAll()) {
            EventObserverMap tagsObserverMap = observerManger.topicOf(topic);
            Collection tags = tagsObserverMap.getTagsByLevel(eventLevel);
            if (tags.size() <= 0) continue;
            String tagsExpr = String.join((CharSequence)"||", tags);
            if (tags.contains("*")) {
                subscriptionExpressions.put(topic, FilterExpression.SUB_ALL);
            } else {
                subscriptionExpressions.put(topic, new FilterExpression(tagsExpr));
            }
            log.trace("Rocketmq5 consumer will subscribe [" + topic + "(" + tagsExpr + ")] ok!");
        }
        if (subscriptionExpressions.size() == 0) {
            return null;
        }
        PushConsumerBuilder consumerBuilder = this.serviceProvider.newPushConsumerBuilder();
        consumerBuilder.setClientConfiguration(configuration);
        consumerBuilder.setConsumerGroup(consumerGroup);
        consumerBuilder.setMessageListener((MessageListener)new RocketmqConsumerHandler(this.config, observerManger));
        if (subscriptionExpressions.size() > 0) {
            consumerBuilder.setSubscriptionExpressions(subscriptionExpressions);
        }
        if (this.config.getConsumeThreadNums() > 0) {
            consumerBuilder.setConsumptionThreadCount(this.config.getConsumeThreadNums());
        }
        return consumerBuilder.build();
    }

    @Override
    public void close() throws IOException {
        if (this.consumerOfCluster != null) {
            this.consumerOfCluster.close();
        }
        if (this.consumerOfInstance != null) {
            this.consumerOfInstance.close();
        }
    }
}

