/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.service;

import java.io.Closeable;
import java.io.IOException;
import org.apache.rocketmq.client.apis.ClientException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumer;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqProducer;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqTransactionListener;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventTran;
import org.noear.solon.cloud.model.EventTranListener;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.core.bean.LifecycleBean;

public class CloudEventServiceRocketmqImp
implements CloudEventServicePlus,
Closeable,
LifecycleBean {
    private CloudProps cloudProps;
    private RocketmqProducer producer;
    private RocketmqConsumer consumer;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServiceRocketmqImp(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        RocketmqConfig config = new RocketmqConfig(cloudProps);
        this.producer = new RocketmqProducer(config);
        this.consumer = new RocketmqConsumer(config);
    }

    private void beginTransaction(EventTran transaction) throws CloudEventException {
        if (transaction.getListener(RocketmqTransactionListener.class) != null) {
            return;
        }
        try {
            transaction.setListener((EventTranListener)new RocketmqTransactionListener(this.producer.beginTransaction()));
        }
        catch (Exception e) {
            throw new CloudEventException((Throwable)e);
        }
    }

    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        if (event.created() == 0L) {
            event.created(System.currentTimeMillis());
        }
        if (event.tran() != null) {
            this.beginTransaction(event.tran());
        }
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + "--" + event.topic();
        topicNew = topicNew.replace(".", "_");
        try {
            return this.producer.publish(event, topicNew);
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        topic = topic.replace(".", "_");
        String topicNew = Utils.isEmpty((String)group) ? topic : group + "--" + topic;
        if (Utils.isEmpty((String)tag)) {
            tag = "*";
        }
        this.observerManger.add(topicNew, level, group, topic, tag, qos, observer);
    }

    public void postStart() throws Throwable {
        this.subscribe();
    }

    private void subscribe() {
        if (this.observerManger.topicSize() > 0) {
            try {
                this.consumer.init(this.observerManger);
            }
            catch (ClientException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }

    @Override
    public void close() throws IOException {
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

