/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.solon.integration;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaFilterErrorStrategy;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.strategy.SaStrategy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.Handler;

public class SaTokenFilter
implements Filter {
    public boolean isAnnotation = true;
    protected List<String> includeList = new ArrayList<String>();
    protected List<String> excludeList = new ArrayList<String>();
    protected SaFilterAuthStrategy auth = r -> {};
    protected SaFilterErrorStrategy error = e -> {
        if (e instanceof SaTokenException) {
            throw (SaTokenException)e;
        }
        throw new SaTokenException(e);
    };
    protected SaFilterAuthStrategy beforeAuth = r -> {};

    public SaTokenFilter addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenFilter addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenFilter setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SaTokenFilter setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public SaTokenFilter setAuth(SaFilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SaTokenFilter setError(SaFilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SaTokenFilter setBeforeAuth(SaFilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        try {
            Action action;
            Handler mainHandler = Solon.app().router().matchMain(ctx);
            Action action2 = action = mainHandler instanceof Action ? (Action)mainHandler : null;
            if (this.isAnnotation && action != null) {
                Method method = action.method().getMethod();
                if (((Boolean)SaStrategy.me.isAnnotationPresent.apply(method, SaIgnore.class)).booleanValue()) {
                    return;
                }
                SaStrategy.me.checkMethodAnnotation.accept(method);
            }
            SaRouter.match(this.includeList).notMatch(this.excludeList).check(r -> {
                this.beforeAuth.run((Object)mainHandler);
                this.auth.run((Object)mainHandler);
            });
        }
        catch (StopMatchException mainHandler) {
        }
        catch (SaTokenException e) {
            Object result = e instanceof BackResultException ? e.getMessage() : this.error.run((Throwable)e);
            if (result != null) {
                ctx.render(result);
            }
            ctx.setHandled(true);
            return;
        }
        chain.doFilter(ctx);
    }
}

