/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.solon.integration;

import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaFilterErrorStrategy;
import cn.dev33.satoken.router.SaRouter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;

public class SaTokenPathFilter
implements Filter {
    protected List<String> includeList = new ArrayList<String>();
    protected List<String> excludeList = new ArrayList<String>();
    public SaFilterAuthStrategy auth = r -> {};
    public SaFilterErrorStrategy error = e -> {
        throw new SaTokenException(e);
    };
    public SaFilterAuthStrategy beforeAuth = r -> {};

    public SaTokenPathFilter addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenPathFilter addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenPathFilter setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SaTokenPathFilter setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public SaTokenPathFilter setAuth(SaFilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SaTokenPathFilter setError(SaFilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SaTokenPathFilter setBeforeAuth(SaFilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        try {
            SaRouter.match(this.includeList).notMatch(this.excludeList).check(r -> {
                this.beforeAuth.run(null);
                this.auth.run(null);
            });
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (BackResultException e) {
            ctx.contentType("text/plain; charset=utf-8");
            ctx.output(e.getMessage());
            ctx.setHandled(true);
            ctx.setRendered(true);
            return;
        }
        catch (Throwable e) {
            throw Utils.throwableUnwrap((Throwable)e);
        }
        chain.doFilter(ctx);
    }
}

