/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.solon.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.solon.dao.SaSessionForJson;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.noear.redisx.RedisClient;
import org.noear.redisx.plus.RedisBucket;
import org.noear.snack.ONode;

public class SaTokenDaoOfRedisJson
implements SaTokenDao {
    private final RedisBucket redisBucket;

    public SaTokenDaoOfRedisJson(Properties props) {
        this(new RedisClient(props));
    }

    public SaTokenDaoOfRedisJson(RedisClient redisClient) {
        this.redisBucket = redisClient.getBucket();
        SaStrategy.me.createSession = sessionId -> new SaSessionForJson((String)sessionId);
    }

    public SaSession getSession(String sessionId) {
        Object obj = this.getObject(sessionId);
        if (obj == null) {
            return null;
        }
        return (SaSession)ONode.deserialize((String)obj.toString(), SaSessionForJson.class);
    }

    public String get(String key) {
        return this.redisBucket.get(key);
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.redisBucket.store(key, value, -1);
        } else {
            this.redisBucket.store(key, value, (int)timeout);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.redisBucket.remove(key);
    }

    public long getTimeout(String key) {
        return this.redisBucket.ttl(key);
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        this.redisBucket.delay(key, (int)timeout);
    }

    public Object getObject(String key) {
        return this.get(key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        String value = ONode.serialize((Object)object);
        this.set(key, value, timeout);
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.redisBucket.remove(key);
    }

    public long getObjectTimeout(String key) {
        return this.redisBucket.ttl(key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        this.redisBucket.delay(key, (int)timeout);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        Set keys = this.redisBucket.keys(prefix + "*" + keyword + "*");
        ArrayList list = new ArrayList(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
    }
}

