/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.solon.integration;

import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.filter.SaFilter;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaFilterErrorStrategy;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.strategy.SaAnnotationStrategy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.Gateway;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.route.RoutingTable;

public class SaTokenFilter
implements SaFilter,
Filter {
    public boolean isAnnotation = true;
    public List<String> includeList = new ArrayList<String>();
    public List<String> excludeList = new ArrayList<String>();
    public SaFilterAuthStrategy auth = r -> {};
    public SaFilterErrorStrategy error = e -> {
        if (e instanceof SaTokenException) {
            throw (SaTokenException)e;
        }
        throw new SaTokenException(e);
    };
    public SaFilterAuthStrategy beforeAuth = r -> {};

    public SaTokenFilter addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenFilter addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenFilter setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SaTokenFilter setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public SaTokenFilter setAuth(SaFilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SaTokenFilter setError(SaFilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SaTokenFilter setBeforeAuth(SaFilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        try {
            Action action;
            Handler mainHandler = ctx.mainHandler();
            if (mainHandler == null) {
                mainHandler = Solon.app().router().matchMain(ctx);
            }
            if (mainHandler instanceof Gateway) {
                Gateway gateway = (Gateway)mainHandler;
                RoutingTable mainRouting = gateway.getMainRouting();
                MethodType method = MethodTypeUtil.valueOf((String)ctx.method());
                mainHandler = (Handler)mainRouting.matchOne(ctx.pathNew(), method);
            }
            Action action2 = action = mainHandler instanceof Action ? (Action)mainHandler : null;
            if (this.beforeAuth != null) {
                this.beforeAuth.run((Object)mainHandler);
            }
            Handler finalMainHandler = mainHandler;
            SaRouter.match(this.includeList).notMatch(this.excludeList).check(r -> {
                if (this.authAnno(action)) {
                    this.auth.run((Object)finalMainHandler);
                }
            });
        }
        catch (StopMatchException mainHandler) {
        }
        catch (SaTokenException e) {
            Object result = e instanceof BackResultException ? e.getMessage() : this.error.run((Throwable)e);
            if (result != null) {
                ctx.render(result);
            }
            ctx.setHandled(true);
            return;
        }
        chain.doFilter(ctx);
    }

    private boolean authAnno(Action action) {
        if (this.isAnnotation && action != null) {
            try {
                Method method = action.method().getMethod();
                SaAnnotationStrategy.instance.checkMethodAnnotation.accept((Object)method);
            }
            catch (StopMatchException ignored) {
                return false;
            }
        }
        return true;
    }
}

