/*
 * Decompiled with CFR 0.152.
 */
package io.seata.solon.impl;

import io.seata.solon.annotation.GlobalTransactional;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.util.LinkedHashSet;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;

public class GlobalTransactionalExecutorImpl
implements TransactionalExecutor {
    Invocation inv;
    GlobalTransactional anno;

    public GlobalTransactionalExecutorImpl(Invocation inv, GlobalTransactional anno) {
        this.inv = inv;
        this.anno = anno;
    }

    public Object execute() throws Throwable {
        return this.inv.invoke();
    }

    public TransactionInfo getTransactionInfo() {
        TransactionInfo transactionInfo = new TransactionInfo();
        transactionInfo.setTimeOut(this.anno.timeoutMills());
        transactionInfo.setName(this.getName());
        transactionInfo.setRollbackRules(this.getRollbackRules());
        transactionInfo.setPropagation(this.anno.propagation());
        transactionInfo.setLockRetryInterval(this.anno.lockRetryInterval());
        transactionInfo.setLockRetryTimes(this.anno.lockRetryTimes());
        transactionInfo.setLockStrategyMode(this.anno.lockStrategyMode());
        return transactionInfo;
    }

    private Set<RollbackRule> getRollbackRules() {
        LinkedHashSet<RollbackRule> rollbackRules = new LinkedHashSet<RollbackRule>();
        for (Class<? extends Throwable> clazz : this.anno.rollbackFor()) {
            rollbackRules.add(new RollbackRule(clazz));
        }
        for (String string : this.anno.rollbackForClassName()) {
            rollbackRules.add(new RollbackRule(string));
        }
        for (Class<? extends Throwable> clazz : this.anno.noRollbackFor()) {
            rollbackRules.add((RollbackRule)new NoRollbackRule((Class)clazz));
        }
        for (String string : this.anno.noRollbackForClassName()) {
            rollbackRules.add((RollbackRule)new NoRollbackRule(string));
        }
        return rollbackRules;
    }

    private String getName() {
        if (Utils.isEmpty((String)this.anno.name())) {
            StringBuilder sb = new StringBuilder(this.inv.method().getMethod().getName()).append("(");
            Class<?>[] params = this.inv.method().getMethod().getParameterTypes();
            int in = 0;
            for (Class<?> clazz : params) {
                sb.append(clazz.getName());
                if (++in >= params.length) continue;
                sb.append(", ");
            }
            return sb.append(")").toString();
        }
        return this.anno.name();
    }
}

