/*
 * Decompiled with CFR 0.152.
 */
package io.seata.solon.impl;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.core.event.Event;
import io.seata.core.event.EventBus;
import io.seata.core.event.GuavaEventBus;
import io.seata.core.exception.TmTransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.integration.tx.api.event.DegradeCheckEvent;
import io.seata.solon.annotation.GlobalTransactional;
import io.seata.solon.impl.GlobalTransactionalExecutorImpl;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionRole;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.TransactionalTemplate;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;

public class GlobalTransactionalInterceptor
implements Interceptor {
    private static final AtomicBoolean ATOMIC_DEGRADE_CHECK = new AtomicBoolean(false);
    private static final EventBus EVENT_BUS = new GuavaEventBus("degradeCheckEventBus", true);
    FailureHandler failureHandler;
    TransactionalTemplate transactionalTemplate;

    public GlobalTransactionalInterceptor(TransactionalTemplate transactionalTemplate) {
        this.transactionalTemplate = transactionalTemplate;
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        GlobalTransactional anno = (GlobalTransactional)inv.getMethodAnnotation(GlobalTransactional.class);
        if (anno == null) {
            anno = (GlobalTransactional)inv.getTargetAnnotation(GlobalTransactional.class);
        }
        if (anno == null) {
            return inv.invoke();
        }
        return this.tranInvoke(inv, anno);
    }

    private Object tranInvoke(Invocation inv, GlobalTransactional anno) throws Throwable {
        boolean succeed = true;
        try {
            Object object = this.transactionalTemplate.execute((TransactionalExecutor)new GlobalTransactionalExecutorImpl(inv, anno));
            return object;
        }
        catch (TransactionalExecutor.ExecutionException e) {
            GlobalTransaction globalTransaction = e.getTransaction();
            if (globalTransaction.getGlobalTransactionRole() == GlobalTransactionRole.Participant) {
                throw e.getOriginalException();
            }
            TransactionalExecutor.Code code = e.getCode();
            Throwable cause = e.getCause();
            boolean timeout = this.isTimeoutException(cause);
            switch (code) {
                case RollbackDone: {
                    if (timeout) {
                        throw cause;
                    }
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    succeed = false;
                    this.failureHandler.onBeginFailure(globalTransaction, cause);
                    throw cause;
                }
                case CommitFailure: {
                    succeed = false;
                    this.failureHandler.onCommitFailure(globalTransaction, cause);
                    throw cause;
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(globalTransaction, e.getOriginalException());
                    throw e.getOriginalException();
                }
                case Rollbacking: {
                    this.failureHandler.onRollbacking(globalTransaction, e.getOriginalException());
                    if (timeout) {
                        throw cause;
                    }
                    throw e.getOriginalException();
                }
            }
            throw new ShouldNeverHappenException(String.format("Unknown TransactionalExecutor.Code: %s", code), e.getOriginalException());
        }
        finally {
            if (ATOMIC_DEGRADE_CHECK.get()) {
                EVENT_BUS.post((Event)new DegradeCheckEvent(succeed));
            }
        }
    }

    private boolean isTimeoutException(Throwable th) {
        TmTransactionException exx;
        if (null == th) {
            return false;
        }
        return th instanceof TmTransactionException && TransactionExceptionCode.TransactionTimeout == (exx = (TmTransactionException)th).getCode();
    }
}

