/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.annotation.datasource;

import javax.sql.DataSource;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.rm.datasource.DataSourceProxy;
import org.apache.seata.rm.datasource.SeataDataSourceProxy;
import org.apache.seata.rm.datasource.xa.DataSourceProxyXA;
import org.apache.seata.solon.annotation.datasource.DataSourceProxyHolder;
import org.apache.seata.solon.annotation.datasource.RoutingDataSourceProxyAT;
import org.apache.seata.solon.annotation.datasource.RoutingDataSourceProxyXA;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.data.datasource.RoutingDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeataAutoDataSourceProxyCreator
implements BeanWrap.Proxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoDataSourceProxyCreator.class);
    private final String dataSourceProxyMode;

    public SeataAutoDataSourceProxyCreator(String dataSourceProxyMode) {
        this.dataSourceProxyMode = dataSourceProxyMode;
    }

    public Object getProxy(BeanWrap bw, Object bean) {
        if (!(bean instanceof DataSource)) {
            return bean;
        }
        if (!(bean instanceof SeataDataSourceProxy)) {
            DataSource origin = (DataSource)bean;
            SeataDataSourceProxy proxy = this.buildProxy(origin, this.dataSourceProxyMode);
            DataSourceProxyHolder.put(origin, proxy);
            LOGGER.info("Auto proxy data source '{}' by '{}' mode.", (Object)bw.name(), (Object)this.dataSourceProxyMode);
            return proxy;
        }
        return bean;
    }

    protected SeataDataSourceProxy buildProxy(DataSource origin, String proxyMode) {
        if (BranchType.AT.name().equalsIgnoreCase(proxyMode)) {
            if (origin instanceof RoutingDataSource) {
                return new RoutingDataSourceProxyAT(origin);
            }
            return new DataSourceProxy(origin);
        }
        if (BranchType.XA.name().equalsIgnoreCase(proxyMode)) {
            if (origin instanceof RoutingDataSource) {
                return new RoutingDataSourceProxyXA(origin);
            }
            return new DataSourceProxyXA(origin);
        }
        throw new IllegalArgumentException("Unknown dataSourceProxyMode: " + proxyMode);
    }
}

