/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.autoconfigure.config;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.saga.engine.serializer.Serializer;
import org.apache.seata.saga.engine.serializer.impl.ParamsSerializer;
import org.apache.seata.saga.engine.store.StateLangStore;
import org.apache.seata.saga.engine.store.db.DbAndReportTcStateLogStore;
import org.apache.seata.saga.engine.store.db.DbStateLangStore;
import org.apache.seata.saga.engine.tm.DefaultSagaTransactionalTemplate;
import org.apache.seata.saga.engine.tm.SagaTransactionalTemplate;
import org.apache.seata.saga.impl.DefaultStateMachineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbStateMachineConfig
extends DefaultStateMachineConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbStateMachineConfig.class);
    private DataSource dataSource;
    private String applicationId;
    private String txServiceGroup;
    private String accessKey;
    private String secretKey;
    private String tablePrefix = "seata_";
    private String dbType;
    private SagaTransactionalTemplate sagaTransactionalTemplate;

    public DbStateMachineConfig() {
        try {
            Configuration configuration = ConfigurationFactory.getInstance();
            if (configuration != null) {
                this.setRmReportSuccessEnable(configuration.getBoolean("client.rm.reportSuccessEnable", false));
                this.setSagaBranchRegisterEnable(configuration.getBoolean("client.rm.sagaBranchRegisterEnable", false));
                this.setSagaJsonParser(configuration.getConfig("client.rm.sagaJsonParser", "fastjson"));
                this.applicationId = configuration.getConfig("applicationId");
                this.txServiceGroup = configuration.getConfig("txServiceGroup");
                this.accessKey = configuration.getConfig("accesskey", null);
                this.secretKey = configuration.getConfig("secretkey", null);
                this.setSagaRetryPersistModeUpdate(configuration.getBoolean("client.rm.sagaRetryPersistModeUpdate", false));
                this.setSagaCompensatePersistModeUpdate(configuration.getBoolean("client.rm.sagaCompensatePersistModeUpdate", false));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Load SEATA configuration failed, use default configuration instead.", (Throwable)e);
        }
    }

    public static String getDbTypeFromDataSource(DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("datasource required not null!");
        }
        this.dbType = DbStateMachineConfig.getDbTypeFromDataSource(this.dataSource);
        if (this.getStateLogStore() == null) {
            DbAndReportTcStateLogStore dbStateLogStore = new DbAndReportTcStateLogStore();
            dbStateLogStore.setDataSource(this.dataSource);
            dbStateLogStore.setTablePrefix(this.tablePrefix);
            dbStateLogStore.setDbType(this.dbType);
            dbStateLogStore.setDefaultTenantId(this.getDefaultTenantId());
            dbStateLogStore.setSeqGenerator(this.getSeqGenerator());
            if (StringUtils.hasLength((CharSequence)this.getSagaJsonParser())) {
                ParamsSerializer paramsSerializer = new ParamsSerializer();
                paramsSerializer.setJsonParserName(this.getSagaJsonParser());
                dbStateLogStore.setParamsSerializer((Serializer<Object, String>)paramsSerializer);
            }
            if (this.sagaTransactionalTemplate == null) {
                this.sagaTransactionalTemplate = new DefaultSagaTransactionalTemplate();
            }
            dbStateLogStore.setSagaTransactionalTemplate(this.sagaTransactionalTemplate);
            this.setStateLogStore(dbStateLogStore);
        }
        if (this.getStateLangStore() == null) {
            DbStateLangStore dbStateLangStore = new DbStateLangStore();
            dbStateLangStore.setDataSource(this.dataSource);
            dbStateLangStore.setTablePrefix(this.tablePrefix);
            dbStateLangStore.setDbType(this.dbType);
            this.setStateLangStore((StateLangStore)dbStateLangStore);
        }
        super.init();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTxServiceGroup() {
        return this.txServiceGroup;
    }

    public void setTxServiceGroup(String txServiceGroup) {
        this.txServiceGroup = txServiceGroup;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setSagaTransactionalTemplate(SagaTransactionalTemplate sagaTransactionalTemplate) {
        this.sagaTransactionalTemplate = sagaTransactionalTemplate;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}

