/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.tm;

import java.util.List;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.tm.SagaTransactionalTemplate;
import org.apache.seata.tm.api.GlobalTransaction;
import org.apache.seata.tm.api.GlobalTransactionContext;
import org.apache.seata.tm.api.GlobalTransactionRole;
import org.apache.seata.tm.api.TransactionalExecutor;
import org.apache.seata.tm.api.transaction.TransactionHook;
import org.apache.seata.tm.api.transaction.TransactionHookManager;
import org.apache.seata.tm.api.transaction.TransactionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSagaTransactionalTemplate
implements SagaTransactionalTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSagaTransactionalTemplate.class);

    @Override
    public void commitTransaction(GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        try {
            this.triggerBeforeCommit(tx);
            tx.commit();
            this.triggerAfterCommit(tx);
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.CommitFailure);
        }
    }

    @Override
    public void rollbackTransaction(GlobalTransaction tx, Throwable ex) throws TransactionException, TransactionalExecutor.ExecutionException {
        this.triggerBeforeRollback(tx);
        tx.rollback();
        this.triggerAfterRollback(tx);
    }

    @Override
    public GlobalTransaction beginTransaction(TransactionInfo txInfo) throws TransactionalExecutor.ExecutionException {
        GlobalTransaction tx = GlobalTransactionContext.getCurrentOrCreate();
        try {
            this.triggerBeforeBegin(tx);
            tx.begin(txInfo.getTimeOut(), txInfo.getName());
            this.triggerAfterBegin(tx);
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.BeginFailure);
        }
        return tx;
    }

    @Override
    public GlobalTransaction reloadTransaction(String xid) throws TransactionalExecutor.ExecutionException, TransactionException {
        return GlobalTransactionContext.reload((String)xid);
    }

    @Override
    public void reportTransaction(GlobalTransaction tx, GlobalStatus globalStatus) throws TransactionalExecutor.ExecutionException {
        try {
            tx.globalReport(globalStatus);
            this.triggerAfterCompletion(tx);
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.ReportFailure);
        }
    }

    @Override
    public long branchRegister(String resourceId, String clientId, String xid, String applicationData, String lockKeys) throws TransactionException {
        return DefaultResourceManager.get().branchRegister(BranchType.SAGA, resourceId, clientId, xid, applicationData, lockKeys);
    }

    @Override
    public void branchReport(String xid, long branchId, BranchStatus status, String applicationData) throws TransactionException {
        DefaultResourceManager.get().branchReport(BranchType.SAGA, xid, branchId, status, applicationData);
    }

    protected void triggerBeforeBegin(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.beforeBegin();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute beforeBegin in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerAfterBegin(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterBegin();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterBegin in hook {} ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerBeforeRollback(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.beforeRollback();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute beforeRollback in hook {} ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerAfterRollback(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterRollback();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterRollback in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerBeforeCommit(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.beforeCommit();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute beforeCommit in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void triggerAfterCommit(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterCommit();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterCommit in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    @Override
    public void triggerAfterCompletion(GlobalTransaction tx) {
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            for (TransactionHook hook : this.getCurrentHooks()) {
                try {
                    hook.afterCompletion();
                }
                catch (Exception e) {
                    LOGGER.error("Failed execute afterCompletion in hook {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    @Override
    public void cleanUp(GlobalTransaction tx) {
        if (tx == null) {
            throw new EngineExecutionException("Global transaction does not exist. Unable to proceed without a valid global transaction context.", FrameworkErrorCode.ObjectNotExists);
        }
        if (tx.getGlobalTransactionRole() == GlobalTransactionRole.Launcher) {
            TransactionHookManager.clear();
        }
    }

    protected List<TransactionHook> getCurrentHooks() {
        return TransactionHookManager.getHooks();
    }
}

