/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.seata.saga.engine.config.AbstractStateMachineConfig;
import org.apache.seata.saga.engine.expression.ExpressionFactory;
import org.apache.seata.saga.engine.expression.ExpressionFactoryManager;
import org.apache.seata.saga.engine.expression.snel.SolonExpressionFactory;
import org.apache.seata.saga.engine.invoker.ServiceInvoker;
import org.apache.seata.saga.engine.invoker.ServiceInvokerManager;
import org.apache.seata.saga.engine.invoker.SolonServiceInvoker;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.util.ResourceUtil;

public class DefaultStateMachineConfig
extends AbstractStateMachineConfig {
    private AppContext applicationContext;
    private String RESOURCES = "classpath*:seata/saga/statelang/**/*.json";

    public void init() throws Exception {
        super.init();
        this.registerStateMachineDef();
        this.registerSpringElExpressionFactoryManager();
        this.registerSpringBeanServiceInvoker();
    }

    private void registerStateMachineDef() throws IOException {
        Collection registerResources = ResourceUtil.scanResources((String)this.RESOURCES);
        InputStream[] resourceAsStreamArray = new InputStream[registerResources.size()];
        Iterator iterator = registerResources.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String resource = (String)iterator.next();
            resourceAsStreamArray[i] = ResourceUtil.getResourceAsStream((String)resource);
            ++i;
        }
        this.getStateMachineRepository().registryByResources(resourceAsStreamArray, this.getDefaultTenantId());
    }

    private void registerSpringElExpressionFactoryManager() {
        ExpressionFactoryManager expressionFactoryManager = this.getExpressionFactoryManager();
        ExpressionFactory bean = (ExpressionFactory)Solon.context().getBean(ExpressionFactory.class);
        if (Objects.nonNull(bean)) {
            expressionFactoryManager.putExpressionFactory("Default", bean);
        } else {
            SolonExpressionFactory springELExpressionFactory = new SolonExpressionFactory();
            expressionFactoryManager.putExpressionFactory("Default", (ExpressionFactory)springELExpressionFactory);
        }
    }

    private void registerSpringBeanServiceInvoker() {
        ServiceInvokerManager manager = this.getServiceInvokerManager();
        SolonServiceInvoker springBeanServiceInvoker = new SolonServiceInvoker();
        springBeanServiceInvoker.setSagaJsonParser(this.getSagaJsonParser());
        springBeanServiceInvoker.setThreadPoolExecutor(this.getThreadPoolExecutor());
        manager.putServiceInvoker("SpringBean", (ServiceInvoker)springBeanServiceInvoker);
    }
}

