/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.autoconfigure.suuport;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.solon.lang.Nullable;

public class CustomizableThreadCreator
implements Serializable {
    private static final char PACKAGE_SEPARATOR = '.';
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final char NESTED_CLASS_SEPARATOR = '$';
    private String threadNamePrefix;
    private int threadPriority = 5;
    private boolean daemon = false;
    private ThreadGroup threadGroup;
    private final AtomicInteger threadCount = new AtomicInteger();

    public CustomizableThreadCreator() {
        this.threadNamePrefix = this.getDefaultThreadNamePrefix();
    }

    public CustomizableThreadCreator(@Nullable String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix != null ? threadNamePrefix : this.getDefaultThreadNamePrefix();
    }

    public void setThreadNamePrefix(@Nullable String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix != null ? threadNamePrefix : this.getDefaultThreadNamePrefix();
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setThreadGroupName(String name) {
        this.threadGroup = new ThreadGroup(name);
    }

    public void setThreadGroup(@Nullable ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    @Nullable
    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Thread createThread(Runnable runnable) {
        Thread thread = new Thread(this.getThreadGroup(), runnable, this.nextThreadName());
        thread.setPriority(this.getThreadPriority());
        thread.setDaemon(this.isDaemon());
        return thread;
    }

    protected String nextThreadName() {
        return this.getThreadNamePrefix() + this.threadCount.incrementAndGet();
    }

    protected String getDefaultThreadNamePrefix() {
        return CustomizableThreadCreator.getShortName(this.getClass().getTypeName()) + "-";
    }

    public static String getShortName(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }
}

