/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.integration;

import javax.sql.DataSource;
import org.apache.seata.rm.tcc.api.LocalTCC;
import org.apache.seata.rm.tcc.api.TwoPhaseBusinessAction;
import org.apache.seata.solon.annotation.AdapterSolonSeaterInterceptor;
import org.apache.seata.solon.annotation.GlobalTransactionalInterceptor;
import org.apache.seata.solon.annotation.TccActionInterceptor;
import org.apache.seata.solon.annotation.datasource.SeataAutoDataSourceProxyCreator;
import org.apache.seata.solon.autoconfigure.SagaAsyncThreadPoolExecutorConfiguration;
import org.apache.seata.solon.autoconfigure.SeataAutoConfiguration;
import org.apache.seata.solon.autoconfigure.SeataSagaAutoConfiguration;
import org.apache.seata.solon.autoconfigure.properties.PropertiesHelper;
import org.apache.seata.solon.autoconfigure.properties.SeataProperties;
import org.apache.seata.solon.autoconfigure.properties.client.ServiceProperties;
import org.apache.seata.solon.integration.intercept.SeataHttpExtension;
import org.apache.seata.solon.integration.intercept.SeataNamiFilter;
import org.apache.seata.solon.integration.intercept.SeataSolonRouterInterceptor;
import org.apache.seata.spring.annotation.GlobalLock;
import org.apache.seata.spring.annotation.GlobalTransactional;
import org.noear.nami.Filter;
import org.noear.nami.NamiManager;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.net.http.HttpExtension;
import org.noear.solon.net.http.HttpExtensionManager;

public class SeataPlugin
implements Plugin {
    public void start(AppContext context) throws Throwable {
        context.getBeanAsync(ServiceProperties.class, bean -> bean.afterPropertiesSet());
        PropertiesHelper.initBeanMap();
        context.beanScan(PropertiesHelper.class);
        context.beanMake(SeataAutoConfiguration.class);
        context.beanMake(SeataSagaAutoConfiguration.class);
        context.beanMake(SagaAsyncThreadPoolExecutorConfiguration.class);
        SeataProperties seataProperties = (SeataProperties)context.getBean(SeataProperties.class);
        SeataAutoDataSourceProxyCreator seataAutoDataSourceProxyCreator = new SeataAutoDataSourceProxyCreator(seataProperties.getDataSourceProxyMode());
        context.subWrapsOfType(DataSource.class, bw -> bw.proxySet((BeanWrap.Proxy)seataAutoDataSourceProxyCreator), Integer.MIN_VALUE);
        if (ClassUtil.hasClass(() -> NamiManager.class)) {
            NamiManager.reg((Filter)new SeataNamiFilter());
        }
        if (ClassUtil.hasClass(() -> HttpExtensionManager.class)) {
            HttpExtensionManager.add((HttpExtension)new SeataHttpExtension());
        }
        context.app().routerInterceptor(Integer.MIN_VALUE, (RouterInterceptor)new SeataSolonRouterInterceptor());
        GlobalTransactionalInterceptor globalTransactionalInterceptor = new GlobalTransactionalInterceptor();
        context.beanInterceptorAdd(GlobalLock.class, (Interceptor)globalTransactionalInterceptor);
        context.beanInterceptorAdd(GlobalTransactional.class, (Interceptor)globalTransactionalInterceptor);
        TccActionInterceptor tccActionInterceptor = new TccActionInterceptor();
        context.beanInterceptorAdd(TwoPhaseBusinessAction.class, (Interceptor)tccActionInterceptor);
        AdapterSolonSeaterInterceptor adapterSolonSeaterInterceptor = new AdapterSolonSeaterInterceptor();
        context.beanInterceptorAdd(GlobalLock.class, (Interceptor)adapterSolonSeaterInterceptor);
        context.beanInterceptorAdd(GlobalTransactional.class, (Interceptor)adapterSolonSeaterInterceptor);
        context.beanInterceptorAdd(LocalTCC.class, (Interceptor)adapterSolonSeaterInterceptor);
        context.beanInterceptorAdd(TwoPhaseBusinessAction.class, (Interceptor)adapterSolonSeaterInterceptor);
    }
}

