/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.annotation;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.CachedConfigurationChangeListener;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.core.rpc.ShutdownHook;
import org.apache.seata.core.rpc.netty.RmNettyRemotingClient;
import org.apache.seata.core.rpc.netty.TmNettyRemotingClient;
import org.apache.seata.rm.RMClient;
import org.apache.seata.tm.TMClient;
import org.apache.seata.tm.api.FailureHandler;
import org.apache.seata.tm.api.FailureHandlerHolder;
import org.noear.solon.core.bean.LifecycleBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTransactionLifecycle
implements CachedConfigurationChangeListener,
LifecycleBean {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalTransactionLifecycle.class);
    private static final int AT_MODE = 1;
    private static final int MT_MODE = 2;
    private static final int ORDER_NUM = 1024;
    private static final int DEFAULT_MODE = 3;
    private final String applicationId;
    private final String txServiceGroup;
    private static String accessKey;
    private static String secretKey;
    private volatile boolean disableGlobalTransaction = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final FailureHandler failureHandlerHook;

    public GlobalTransactionLifecycle(String applicationId, String txServiceGroup, boolean exposeProxy, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, exposeProxy, failureHandlerHook);
    }

    public GlobalTransactionLifecycle(String applicationId, String txServiceGroup, int mode, boolean exposeProxy, FailureHandler failureHandlerHook) {
        this.applicationId = applicationId;
        this.txServiceGroup = txServiceGroup;
        this.failureHandlerHook = failureHandlerHook;
        FailureHandlerHolder.setFailureHandler((FailureHandler)this.failureHandlerHook);
    }

    public static void setAccessKey(String accessKey) {
        GlobalTransactionLifecycle.accessKey = accessKey;
    }

    public static void setSecretKey(String secretKey) {
        GlobalTransactionLifecycle.secretKey = secretKey;
    }

    protected void initClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if ("my_test_tx_group".equals(this.txServiceGroup)) {
            LOGGER.warn("the default value of seata.tx-service-group: {} has already changed to {} since Seata 1.5, please change your default configuration as soon as possible and we don't recommend you to use default tx-service-group's value provided by seata", (Object)"my_test_tx_group", (Object)"default_tx_group");
        }
        if (StringUtils.isNullOrEmpty((String)this.applicationId) || StringUtils.isNullOrEmpty((String)this.txServiceGroup)) {
            throw new IllegalArgumentException(String.format("applicationId: %s, txServiceGroup: %s", this.applicationId, this.txServiceGroup));
        }
        TMClient.init((String)this.applicationId, (String)this.txServiceGroup, (String)accessKey, (String)secretKey);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        RMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
        this.registerSpringShutdownHook();
    }

    protected void registerSpringShutdownHook() {
        ShutdownHook.getInstance().addDisposable((Disposable)TmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup, (String)accessKey, (String)secretKey));
        ShutdownHook.getInstance().addDisposable((Disposable)RmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
    }

    public void start() {
        if (this.disableGlobalTransaction) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Global transaction is disabled.");
            }
            ConfigurationFactory.getInstance().addConfigListener("service.disableGlobalTransaction", (ConfigurationChangeListener)this);
            return;
        }
        if (this.initialized.compareAndSet(false, true)) {
            this.initClient();
        }
    }

    public void stop() {
        ShutdownHook.getInstance().destroyAll();
    }

    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            this.disableGlobalTransaction = Boolean.parseBoolean(event.getNewValue().trim());
            if (!this.disableGlobalTransaction && this.initialized.compareAndSet(false, true)) {
                LOGGER.info("{} config changed, old value:true, new value:{}", (Object)"service.disableGlobalTransaction", (Object)event.getNewValue());
                this.initClient();
                ConfigurationFactory.getInstance().removeConfigListener("service.disableGlobalTransaction", (ConfigurationChangeListener)this);
            }
        }
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getTxServiceGroup() {
        return this.txServiceGroup;
    }

    public static String getAccessKey() {
        return accessKey;
    }

    public static String getSecretKey() {
        return secretKey;
    }
}

