/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.autoconfigure;

import org.apache.seata.solon.annotation.GlobalTransactionLifecycle;
import org.apache.seata.solon.autoconfigure.properties.SeataProperties;
import org.apache.seata.tm.api.DefaultFailureHandlerImpl;
import org.apache.seata.tm.api.FailureHandler;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
@Condition(onProperty="${seata..enabled:true} = true")
public class SeataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoConfiguration.class);

    @Bean(value="failureHandler", typed=true)
    @Condition(onMissingBean=FailureHandler.class)
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean
    @Condition(onMissingBean=GlobalTransactionLifecycle.class)
    public GlobalTransactionLifecycle globalTransactionLifecycle(SeataProperties seataProperties, FailureHandler failureHandler) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata");
        }
        GlobalTransactionLifecycle.setAccessKey(seataProperties.getAccessKey());
        GlobalTransactionLifecycle.setSecretKey(seataProperties.getSecretKey());
        return new GlobalTransactionLifecycle(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), seataProperties.isExposeProxy(), failureHandler);
    }
}

