/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.autoconfigure.provider;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ExtConfigurationProvider;
import org.apache.seata.solon.autoconfigure.StarterConstants;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonConfigurationProvider
implements ExtConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolonConfigurationProvider.class);
    private static final String INTERCEPT_METHOD_PREFIX = "get";
    private static final Map<String, Object> PROPERTY_BEAN_INSTANCE_MAP = new ConcurrentHashMap<String, Object>(64);

    public Configuration provide(Configuration originalConfiguration) {
        return (Configuration)Proxy.newProxyInstance((ClassLoader)AppClassLoader.global(), new Class[]{Configuration.class}, (proxy, method, args) -> {
            if (method.getName().startsWith(INTERCEPT_METHOD_PREFIX) && args.length > 0) {
                String rawDataId = (String)args[0];
                Class dataType = ReflectionUtil.getWrappedClass(method.getReturnType());
                Object result = originalConfiguration.getConfigFromSys(rawDataId);
                if (result == null) {
                    String dataId = this.convertDataId(rawDataId);
                    result = this.getConfigFromEnvironment(dataId, dataType);
                    if (result != null) {
                        return result;
                    }
                    if (args.length > 1 && (result = args[1]) != null) {
                        if (dataType.isAssignableFrom(result.getClass())) {
                            return result;
                        }
                        result = null;
                    }
                    try {
                        result = this.getDefaultValueFromPropertyObject(dataId);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Get config '{}' default value from the property object failed:", (Object)dataId, (Object)t);
                    }
                }
                if (result != null) {
                    if (dataType.isAssignableFrom(result.getClass())) {
                        return result;
                    }
                    return this.convertType(result, dataType);
                }
            }
            return method.invoke((Object)originalConfiguration, args);
        });
    }

    private Object getDefaultValueFromPropertyObject(String dataId) throws IllegalAccessException {
        String propertyPrefix = this.getPropertyPrefix(dataId);
        String propertySuffix = this.getPropertySuffix(dataId);
        Class<?> propertyClass = StarterConstants.PROPERTY_BEAN_MAP.get(propertyPrefix);
        if (propertyClass == null) {
            throw new ShouldNeverHappenException("PropertyClass for prefix: [" + propertyPrefix + "] should not be null.");
        }
        Object propertyObj = CollectionUtils.computeIfAbsent(PROPERTY_BEAN_INSTANCE_MAP, (Object)propertyPrefix, k -> {
            try {
                return propertyClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.warn("PropertyClass for prefix: [" + propertyPrefix + "] should not be null. error :" + e.getMessage(), (Throwable)e);
                return null;
            }
        });
        Objects.requireNonNull(propertyObj, () -> "Instantiate the property object fail: " + propertyClass.getName());
        return this.getDefaultValueFromPropertyObject(propertyObj, propertySuffix);
    }

    @Nullable
    private Object getDefaultValueFromPropertyObject(Object propertyObj, String fieldName) throws IllegalAccessException {
        Field field;
        Optional<Field> fieldOptional = Stream.of(propertyObj.getClass().getDeclaredFields()).filter(f -> f.getName().equalsIgnoreCase(fieldName)).findAny();
        if (fieldOptional.isPresent() && !Map.class.isAssignableFrom((field = fieldOptional.get()).getType())) {
            field.setAccessible(true);
            return field.get(propertyObj);
        }
        return null;
    }

    private String convertDataId(String rawDataId) {
        if (rawDataId.endsWith("grouplist")) {
            String suffix = StringUtils.removeStart((String)StringUtils.removeEnd((String)rawDataId, (String)".grouplist"), (String)"service.");
            return "seata.service.grouplist." + suffix;
        }
        return "seata." + rawDataId;
    }

    private String getPropertyPrefix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "seata.service";
        }
        if (dataId.contains("grouplist")) {
            return "seata.service";
        }
        return StringUtils.substringBeforeLast((String)dataId, (String)String.valueOf('.'));
    }

    private String getPropertySuffix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "vgroupMapping";
        }
        if (dataId.contains("grouplist")) {
            return "grouplist";
        }
        return StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
    }

    @Nullable
    private Object getConfigFromEnvironment(String dataId, Class<?> dataType) {
        String val = Solon.cfg().get(dataId);
        if (val == null) {
            return null;
        }
        return ConvertUtil.tryTo(dataType, (String)val);
    }

    private Object convertType(Object configValue, Class<?> dataType) {
        if (String.class.equals(dataType)) {
            return String.valueOf(configValue);
        }
        if (Long.class.equals(dataType)) {
            return Long.parseLong(String.valueOf(configValue));
        }
        if (Integer.class.equals(dataType)) {
            return Integer.parseInt(String.valueOf(configValue));
        }
        if (Short.class.equals(dataType)) {
            return Short.parseShort(String.valueOf(configValue));
        }
        if (Boolean.class.equals(dataType)) {
            return Boolean.parseBoolean(String.valueOf(configValue));
        }
        if (Duration.class.equals(dataType)) {
            return Duration.parse(String.valueOf(configValue));
        }
        return configValue;
    }
}

