/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.autoconfigure;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.seata.solon.autoconfigure.properties.SagaAsyncThreadPoolProperties;
import org.apache.seata.solon.autoconfigure.suuport.ThreadPoolExecutorFactoryBean;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;

@Configuration
@Condition(onExpression="${seata.saga.stateMachine.asyncThreadPool.enableAsync:false} == 'true'")
public class SagaAsyncThreadPoolExecutorConfiguration {
    @Bean(value="seataSagaRejectedExecutionHandler")
    @Condition(onMissingBean=RejectedExecutionHandler.class)
    public RejectedExecutionHandler sagaRejectedExecutionHandler() {
        return new ThreadPoolExecutor.CallerRunsPolicy();
    }

    @Bean(value="seataSagaAsyncThreadPoolExecutor")
    @Condition(onMissingBean=ThreadPoolExecutor.class)
    public ThreadPoolExecutor sagaAsyncThreadPoolExecutor(SagaAsyncThreadPoolProperties properties, @Inject(value="seataSagaRejectedExecutionHandler") RejectedExecutionHandler rejectedExecutionHandler) {
        ThreadPoolExecutorFactoryBean threadFactory = new ThreadPoolExecutorFactoryBean();
        threadFactory.setBeanName("sagaStateMachineThreadPoolExecutorFactory");
        threadFactory.setThreadNamePrefix("sagaAsyncExecute-");
        threadFactory.setCorePoolSize(properties.getCorePoolSize());
        threadFactory.setMaxPoolSize(properties.getMaxPoolSize());
        threadFactory.setKeepAliveSeconds(properties.getKeepAliveTime());
        return new ThreadPoolExecutor(properties.getCorePoolSize(), properties.getMaxPoolSize(), properties.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, rejectedExecutionHandler);
    }
}

