/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.autoconfigure;

import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import javax.sql.DataSource;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.StateMachineEngine;
import org.apache.seata.saga.engine.impl.ProcessCtrlStateMachineEngine;
import org.apache.seata.saga.rm.StateMachineEngineHolder;
import org.apache.seata.solon.autoconfigure.config.DbStateMachineConfig;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
@Condition(onExpression="${seata.saga.enabled:true} == 'true'")
public class SeataSagaAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataSagaAutoConfiguration.class);
    public static final String SAGA_DATA_SOURCE_BEAN_NAME = "seataSagaDataSource";
    public static final String SAGA_ASYNC_THREAD_POOL_EXECUTOR_BEAN_NAME = "seataSagaAsyncThreadPoolExecutor";
    public static final String SAGA_REJECTED_EXECUTION_HANDLER_BEAN_NAME = "seataSagaRejectedExecutionHandler";

    @Bean
    @Condition(onBean=DataSource.class, onMissingBean=StateMachineConfig.class)
    public StateMachineConfig dbStateMachineConfig(DataSource dataSource, @Inject(value="seataSagaDataSource", required=false) DataSource sagaDataSource, @Inject(value="seataSagaAsyncThreadPoolExecutor", required=false) ThreadPoolExecutor threadPoolExecutor, @Inject(value="${solon.app.name:}") String applicationId, @Inject(value="${seata.txServiceGroup:}") String txServiceGroup, @Inject(value="${seata.saga.stateMachine.enableAsync}", required=false) Boolean enableAsync) throws Exception {
        DbStateMachineConfig config = new DbStateMachineConfig();
        config.setDataSource(sagaDataSource != null ? sagaDataSource : dataSource);
        config.setApplicationId(applicationId);
        config.setTxServiceGroup(txServiceGroup);
        if (Objects.equals(enableAsync, Boolean.TRUE)) {
            config.setEnableAsync(true);
        }
        if (threadPoolExecutor != null) {
            config.setThreadPoolExecutor(threadPoolExecutor);
        }
        config.afterPropertiesSet();
        return config;
    }

    @Bean
    @Condition(onMissingBean=StateMachineEngine.class, onBean=StateMachineConfig.class)
    public StateMachineEngine stateMachineEngine(StateMachineConfig config) {
        ProcessCtrlStateMachineEngine engine = new ProcessCtrlStateMachineEngine();
        engine.setStateMachineConfig(config);
        StateMachineEngineHolder.setStateMachineEngine((StateMachineEngine)engine);
        return engine;
    }
}

