/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.solon.integration.intercept;

import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.solon.integration.intercept.XidResource;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeataSolonRouterInterceptor
implements RouterInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataSolonRouterInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIntercept(Context ctx, Handler mainHandler, RouterInterceptorChain chain) throws Throwable {
        String rpcXid = ctx.header("TX_XID");
        this.bindXid(rpcXid);
        try {
            chain.doIntercept(ctx, mainHandler);
        }
        finally {
            if (RootContext.inGlobalTransaction()) {
                this.cleanXid(rpcXid);
            }
        }
    }

    protected boolean bindXid(String rpcXid) {
        String xid = RootContext.getXID();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in RootContext[{}] xid in HttpContext[{}]", (Object)xid, (Object)rpcXid);
        }
        if (StringUtils.isBlank((String)xid) && StringUtils.isNotBlank((String)rpcXid)) {
            RootContext.bind((String)rpcXid);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind[{}] to RootContext", (Object)rpcXid);
            }
        }
        return true;
    }

    protected void cleanXid(String rpcXid) {
        XidResource.cleanXid(rpcXid);
    }
}

